/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments;

import com.recalot.common.builder.DataSplitterBuilder;
import com.recalot.common.builder.Initiator;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.experiments.access.ExperimentAccess;
import com.recalot.model.experiments.splitter.RandomNFoldDataSplitter;
import com.recalot.model.experiments.splitter.RandomPercentageDataSplitter;
import com.recalot.model.experiments.splitter.TimeBasedDataSplitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
Initiator {
    private ExperimentAccess access;
    private ArrayList<DataSplitterBuilder> splitters;

    public void start(BundleContext context) {
        this.access = new ExperimentAccess(context);
        context.registerService(com.recalot.common.interfaces.model.experiment.ExperimentAccess.class.getName(), (Object)this.access, null);
        this.splitters = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("random-nfold", RandomNFoldDataSplitter.class.getName());
        map.put("random-percentage", RandomPercentageDataSplitter.class.getName());
        map.put("timebased", TimeBasedDataSplitter.class.getName());
        for (String key : map.keySet()) {
            try {
                ConfigurationItem[] items;
                DataSplitterBuilder builder = new DataSplitterBuilder((Initiator)this, (String)map.get(key), key, "");
                for (ConfigurationItem item : items = Activator.getConfigurationItems((String)map.get(key))) {
                    builder.setConfiguration(item);
                }
                this.splitters.add(builder);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        for (DataSplitterBuilder splitter : this.splitters) {
            context.registerService(DataSplitterBuilder.class.getName(), (Object)splitter, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.access != null) {
            this.access.close();
            this.access = null;
        }
        if (this.splitters != null) {
            for (DataSplitterBuilder splitter : this.splitters) {
                splitter.close();
            }
            this.splitters = null;
        }
    }

    public Object createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ConfigurationItem[] getConfigurationItems(String className) {
        HashMap<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();
        try {
            for (Class<?> recommender = Class.forName(className); recommender != null; recommender = recommender.getSuperclass()) {
                Configuration[] annotations;
                Configuration config;
                if (recommender.isAnnotationPresent(Configuration.class) && (config = recommender.getAnnotation(Configuration.class)) != null && !items.containsKey(config.key())) {
                    items.put(config.key(), new ConfigurationItem(config.key(), config.type(), config.value(), config.requirement(), config.description(), new ArrayList<String>(Arrays.asList(config.options()))));
                }
                if (!recommender.isAnnotationPresent(Configurations.class)) continue;
                for (Configuration t : annotations = recommender.getAnnotation(Configurations.class).value()) {
                    if (items.containsKey(t.key())) continue;
                    items.put(t.key(), new ConfigurationItem(t.key(), t.type(), t.value(), t.requirement(), t.description(), new ArrayList<String>(Arrays.asList(t.options()))));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return items.values().toArray(new ConfigurationItem[items.size()]);
    }
}

