/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.common;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Servlet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    private Map<String, Map> servletsAndResources;
    private HttpService httpService;
    public String Servlet = "servlet".intern();
    public String Dictionary = "dictionary".intern();
    public String HttpContext = "httpContext".intern();
    public String FilePath = "filePath".intern();

    public HttpServiceTracker(BundleContext context) {
        super(context, HttpService.class.getName(), null);
        this.servletsAndResources = new Hashtable<String, Map>();
        this.initialize();
    }

    private void initialize() {
        ServiceReference references = this.context.getServiceReference(HttpService.class.getName());
        if (references != null) {
            this.httpService = (HttpService)this.context.getService(references);
        }
    }

    public void removedService(ServiceReference reference, Object service) {
        this.unregisterQueue();
        this.httpService = null;
    }

    public Object addingService(ServiceReference reference) {
        this.httpService = (HttpService)this.context.getService(reference);
        this.registerQueue();
        return this.httpService;
    }

    private void registerQueue() {
        if (this.servletsAndResources != null && this.httpService != null) {
            for (String path : this.servletsAndResources.keySet()) {
                Map info = this.servletsAndResources.get(path);
                if (info.containsKey(this.Servlet)) {
                    this.registerServlet(path, (Servlet)info.get(this.Servlet), (Dictionary)info.get(this.Dictionary), (HttpContext)info.get(this.HttpContext));
                    continue;
                }
                if (!info.containsKey(this.FilePath)) continue;
                this.registerResources(path, (String)info.get(this.FilePath), (HttpContext)info.get(this.HttpContext));
            }
        }
    }

    private void unregisterQueue() {
        if (this.servletsAndResources != null && this.httpService != null) {
            for (String path : this.servletsAndResources.keySet()) {
                this.unregister(path);
            }
        }
    }

    public void registerServlet(String path, Servlet servlet, Dictionary dictionary, HttpContext httpContext) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put(this.Servlet, servlet);
        if (dictionary != null) {
            info.put(this.Dictionary, dictionary);
        }
        if (httpContext != null) {
            info.put(this.HttpContext, httpContext);
        }
        this.servletsAndResources.put(path, info);
        if (this.httpService != null) {
            try {
                this.httpService.registerServlet(path, servlet, dictionary, httpContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void registerResources(String path, String filePath, HttpContext httpContext) {
        if (this.httpService != null) {
            try {
                this.httpService.registerResources(path, filePath, httpContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            Hashtable<String, String> info = new Hashtable<String, String>();
            info.put(this.FilePath, filePath);
            if (httpContext != null) {
                info.put(this.HttpContext, (String)httpContext);
            }
            this.servletsAndResources.put(path, info);
        }
    }

    public void unregister(String path) {
        if (this.httpService != null) {
            try {
                this.httpService.unregister(path);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

