/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.common;

import com.recalot.common.configuration.ConfigurationService;
import com.recalot.views.common.HttpServiceTracker;
import java.io.Closeable;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;

public class WebService
extends ConfigurationService
implements Closeable {
    private final BundleContext context;
    private String lastPath;
    private HttpServiceTracker httpTracker;
    private HttpServlet servlet;
    public String PATH = "path";

    public WebService(String id, BundleContext context, HttpServlet servlet, Dictionary config) {
        this.setConfig(config);
        this.setPId(id);
        this.servlet = servlet;
        this.context = context;
    }

    @Override
    public void close() {
        this.httpTracker.close();
    }

    public void onUpdate() {
        if (this.lastPath == null || !this.lastPath.equals(this.getConfig().get(this.getPId() + "." + this.PATH))) {
            this.httpTracker.unregister(this.lastPath);
            this.lastPath = (String)this.getConfig().get(this.getPId() + "." + this.PATH);
            this.httpTracker.registerServlet(this.lastPath, (Servlet)this.servlet, null, null);
        }
    }

    public void initialize() {
        this.httpTracker = new HttpServiceTracker(this.context);
        this.httpTracker.open();
        this.lastPath = this.getConfig().get(this.getPId() + "." + this.PATH) != null ? (String)this.getConfig().get(this.getPId() + "." + this.PATH) : "/";
        this.httpTracker.registerServlet(this.lastPath, (Servlet)this.servlet, null, null);
    }

    public static void processOptionsRequest(HttpServletRequest req, HttpServletResponse res, String allow) {
        res.setHeader("Access-Control-Allow-Origin", "*");
        res.setHeader("Allow", allow);
        res.setHeader("Access-Control-Allow-Methods", allow);
        res.setHeader("Access-Control-Allow-Headers", "Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
    }
}

