/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.access;

import com.recalot.common.Helper;
import com.recalot.common.communication.Message;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import com.recalot.common.interfaces.model.experiment.Experiment;
import com.recalot.common.interfaces.model.experiment.Metric;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.BundleContext;

public class ExperimentAccess
implements com.recalot.common.interfaces.model.experiment.ExperimentAccess {
    private final BundleContext context;
    private final ConcurrentHashMap<String, Experiment> experiments;
    private final ConcurrentHashMap<String, Thread> threads;
    private ConcurrentLinkedQueue<Experiment> queue;

    public ExperimentAccess(BundleContext context) {
        this.context = context;
        this.experiments = new ConcurrentHashMap();
        this.threads = new ConcurrentHashMap();
        this.queue = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Experiment getExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
        synchronized (concurrentHashMap) {
            if (this.experiments.containsKey(id)) {
                return this.experiments.get(id);
            }
        }
        throw new NotFoundException(String.format("Experiment with id %s not found.", id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message deleteExperiment(String id) throws BaseException {
        ConcurrentHashMap<String, Experiment> concurrentHashMap = this.experiments;
        synchronized (concurrentHashMap) {
            if (this.experiments.containsKey(id)) {
                this.experiments.remove(id);
                if (this.threads.containsKey(id)) {
                    this.threads.get(id).interrupt();
                    this.threads.remove(id);
                }
                return new Message("Delete successful", String.format("Experiment with id %s successful deleted.", id), Message.Status.INFO);
            }
        }
        throw new NotFoundException(String.format("Experiment with id %s not found.", id));
    }

    public List<Experiment> getExperiments() throws BaseException {
        return new ArrayList<Experiment>(this.experiments.values());
    }

    public Experiment createExperiment(Recommender[] recommender, DataSource dataSource, DataSplitter splitter, HashMap<String, Metric[]> metrics, ContextProvider context, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.ExperimentId);
        if (id == null || id.isEmpty()) {
            id = UUID.randomUUID().toString();
        }
        if (this.threads.containsKey(id) || this.experiments.containsKey(id)) {
            throw new AlreadyExistsException("An experiment with the id %s already exists. Please first delete the experiment.", id);
        }
        if (param.get(Helper.Keys.MetricIDs) == null) {
            throw new MissingArgumentException("The argument %s is missing.", Helper.Keys.MetricIDs);
        }
        com.recalot.common.impl.experiment.Experiment experiment = new com.recalot.common.impl.experiment.Experiment(id, dataSource, splitter, recommender, metrics, context, param);
        if (this.threads.size() > 0) {
            this.queue.add((Experiment)experiment);
        } else {
            this.run((Experiment)experiment);
        }
        this.experiments.put(experiment.getId(), (Experiment)experiment);
        return experiment;
    }

    private void runNext() {
        Experiment experiment;
        if (this.queue.size() > 0 && (experiment = this.queue.poll()) != null) {
            this.run(experiment);
        }
    }

    private void run(final Experiment experiment) {
        if (experiment != null) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    experiment.run();
                    ExperimentAccess.this.threads.remove(experiment.getId());
                    ExperimentAccess.this.runNext();
                }
            };
            this.threads.put(experiment.getId(), thread);
            thread.start();
        }
    }

    public String getKey() {
        return "experiment-access";
    }

    public String getDescription() {
        return null;
    }

    public void close() throws IOException {
    }
}

