/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.HashBasedTable;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.GraphicRecommender;
import librec.util.Gamma;

public class LDA
extends GraphicRecommender {
    public LDA() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        this.PukSum = new DenseMatrix(this.numUsers, this.numFactors);
        this.PkiSum = new DenseMatrix(this.numFactors, this.numItems);
        this.Nuk = new DenseMatrix(this.numUsers, this.numFactors);
        this.Nu = new DenseVector(this.numUsers);
        this.Nki = new DenseMatrix(this.numFactors, this.numItems);
        this.Nk = new DenseVector(this.numFactors);
        this.alpha = new DenseVector(this.numFactors);
        this.alpha.setAll(this.initAlpha);
        this.beta = new DenseVector(this.numItems);
        this.beta.setAll(this.initBeta);
        this.z = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            int t = (int)(Math.random() * (double)this.numFactors);
            this.z.put((Object)u, (Object)i, (Object)t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int k;
            int u = me.row();
            int i = me.column();
            int t = (Integer)this.z.get((Object)u, (Object)i);
            this.Nuk.add(u, t, -1.0);
            this.Nu.add(u, -1.0);
            this.Nki.add(t, i, -1.0);
            this.Nk.add(t, -1.0);
            double[] p = new double[this.numFactors];
            for (k = 0; k < this.numFactors; ++k) {
                p[k] = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha) * (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
            }
            for (k = 1; k < p.length; ++k) {
                int n = k;
                p[n] = p[n] + p[k - 1];
            }
            double rand = Math.random() * p[this.numFactors - 1];
            for (t = 0; t < p.length && !(rand < p[t]); ++t) {
            }
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            this.Nki.add(t, i, 1.0);
            this.Nk.add(t, 1.0);
            this.z.put((Object)u, (Object)i, (Object)t);
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (int k = 0; k < this.numFactors; ++k) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                numerator += Gamma.digamma(this.Nuk.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.Nu.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
            }
            if (numerator == 0.0) continue;
            this.alpha.set(k, ak * (numerator / denominator));
        }
        for (int i = 0; i < this.numItems; ++i) {
            double bi = this.beta.get(i);
            numerator = 0.0;
            denominator = 0.0;
            for (int k = 0; k < this.numFactors; ++k) {
                numerator += Gamma.digamma(this.Nki.get(k, i) + bi) - Gamma.digamma(bi);
                denominator += Gamma.digamma(this.Nk.get(k) + sumBeta) - Gamma.digamma(sumBeta);
            }
            if (numerator == 0.0) continue;
            this.beta.set(i, bi * (numerator / denominator));
        }
    }

    @Override
    protected void readoutParams() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        double val = 0.0;
        for (int u = 0; u < this.numUsers; ++u) {
            for (int k = 0; k < this.numFactors; ++k) {
                val = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha);
                this.PukSum.add(u, k, val);
            }
        }
        for (int k = 0; k < this.numFactors; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                val = (this.Nki.get(k, i) + this.beta.get(i)) / (this.Nk.get(k) + sumBeta);
                this.PkiSum.add(k, i, val);
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.Puk = this.PukSum.scale(1.0 / (double)this.numStats);
        this.Pki = this.PkiSum.scale(1.0 / (double)this.numStats);
    }

    @Override
    public double ranking(int u, int j) throws Exception {
        return DenseMatrix.product(this.Puk, u, this.Pki, j);
    }
}

