/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.DiagMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;

@Configuration(key="alpha", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)
public class WRMF
extends IterativeRecommender {
    public double alpha;

    public WRMF() {
        this.isRankingPred = true;
    }

    @Override
    public void buildModel() throws Exception {
        DenseMatrix X = this.P;
        DenseMatrix Y = this.Q;
        for (int iter = 1; iter <= this.numIters; ++iter) {
            DenseMatrix Yt = Y.transpose();
            DenseMatrix YtY = Yt.mult(Y);
            for (int u = 0; u < this.numUsers; ++u) {
                DiagMatrix Cu = DiagMatrix.eye(this.numItems);
                SparseVector pu = this.trainMatrix.row(u);
                for (VectorEntry ve : pu) {
                    int i = ve.index();
                    Cu.add(i, i, this.alpha * ve.get());
                }
                for (VectorEntry ve : pu) {
                    ve.set(ve.get() > 0.0 ? 1.0 : 0.0);
                }
                DiagMatrix CuI = Cu.minus(1.0);
                DenseMatrix YtCuY = YtY.add(Yt.mult(CuI).mult(Y));
                DenseMatrix Wu = YtCuY.add(DiagMatrix.eye(this.numFactors).scale(this.regU)).inv();
                DenseMatrix YtCu = Yt.mult(Cu);
                DenseVector xu = Wu.mult(YtCu).mult(pu);
                X.setRow(u, xu);
            }
            DenseMatrix Xt = X.transpose();
            DenseMatrix XtX = Xt.mult(X);
            for (int i = 0; i < this.numItems; ++i) {
                DiagMatrix Ci = DiagMatrix.eye(this.numUsers);
                SparseVector pi = this.trainMatrix.column(i);
                for (VectorEntry ve : pi) {
                    int u = ve.index();
                    Ci.add(u, u, this.alpha * ve.get());
                }
                for (VectorEntry ve : pi) {
                    ve.set(ve.get() > 0.0 ? 1.0 : 0.0);
                }
                DiagMatrix CiI = Ci.minus(1.0);
                DenseMatrix XtCiX = XtX.add(Xt.mult(CiI).mult(X));
                DenseMatrix Wi = XtCiX.add(DiagMatrix.eye(this.numFactors).scale(this.regI)).inv();
                DenseMatrix XtCi = Xt.mult(Ci);
                DenseVector yi = Wi.mult(XtCi).mult(pi);
                Y.setRow(i, yi);
            }
        }
    }
}

