/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.GraphicRecommender;

@Configurations(value={@Configuration(key="Ku", type=ConfigurationItem.ConfigurationItemType.Integer, value="20"), @Configuration(key="Kv", type=ConfigurationItem.ConfigurationItemType.Integer, value="10"), @Configuration(key="au", type=ConfigurationItem.ConfigurationItemType.Double, value="0.1", description="alpha for user"), @Configuration(key="av", type=ConfigurationItem.ConfigurationItemType.Double, value="0.1", description="alpha for item"), @Configuration(key="bl", type=ConfigurationItem.ConfigurationItemType.Double, value="0.1", description="beta for rating levels"), @Configuration(key="burnIn", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double, description="burn-in period", value="2000"), @Configuration(key="sampleLag", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="500", description="sample lag (if -1 only one sample taken)"), @Configuration(key="numIters", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Integer, value="5000")})
public class LDCC
extends GraphicRecommender {
    private Table<Integer, Integer, Integer> Zu;
    private Table<Integer, Integer, Integer> Zv;
    private DenseMatrix Nui;
    private DenseMatrix Nvj;
    private DenseVector Nv;
    private int[][][] Nijl;
    private DenseMatrix Nij;
    public int Ku;
    public int Kv;
    public double au;
    public double av;
    public double bl;
    private DenseMatrix PIu;
    private DenseMatrix PIv;
    private DenseMatrix PIuSum;
    private DenseMatrix PIvSum;
    private double[][][] Pijl;
    private double[][][] PijlSum;

    @Override
    public void initModel() throws Exception {
        this.Nui = new DenseMatrix(this.numUsers, this.Ku);
        this.Nu = new DenseVector(this.numUsers);
        this.Nvj = new DenseMatrix(this.numItems, this.Kv);
        this.Nv = new DenseVector(this.numItems);
        this.Nijl = new int[this.Ku][this.Kv][this.numLevels];
        this.Nij = new DenseMatrix(this.Ku, this.Kv);
        this.Zu = HashBasedTable.create();
        this.Zv = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int v = me.column();
            double rate = me.get();
            int l = ratingScale.indexOf(rate);
            int i = (int)((double)this.Ku * Math.random());
            int j = (int)((double)this.Kv * Math.random());
            this.Nui.add(u, i, 1.0);
            this.Nu.add(u, 1.0);
            this.Nvj.add(v, j, 1.0);
            this.Nv.add(v, 1.0);
            int[] nArray = this.Nijl[i][j];
            int n = l;
            nArray[n] = nArray[n] + 1;
            this.Nij.add(i, j, 1.0);
            this.Zu.put((Object)u, (Object)v, (Object)i);
            this.Zv.put((Object)u, (Object)v, (Object)j);
        }
        this.PIuSum = new DenseMatrix(this.numUsers, this.Ku);
        this.PIvSum = new DenseMatrix(this.numItems, this.Kv);
        this.Pijl = new double[this.Ku][this.Kv][this.numLevels];
        this.PijlSum = new double[this.Ku][this.Kv][this.numLevels];
    }

    @Override
    protected void eStep() {
        for (MatrixEntry me : this.trainMatrix) {
            int n;
            int m;
            int u = me.row();
            int v = me.column();
            double rate = me.get();
            int l = ratingScale.indexOf(rate);
            int i = (Integer)this.Zu.get((Object)u, (Object)v);
            int j = (Integer)this.Zv.get((Object)u, (Object)v);
            this.Nui.add(u, i, -1.0);
            this.Nu.add(u, -1.0);
            this.Nvj.add(v, j, -1.0);
            this.Nv.add(v, -1.0);
            int[] nArray = this.Nijl[i][j];
            int n2 = l;
            nArray[n2] = nArray[n2] - 1;
            this.Nij.add(i, j, -1.0);
            DenseMatrix probs = new DenseMatrix(this.Ku, this.Kv);
            double sum = 0.0;
            for (int m2 = 0; m2 < this.Ku; ++m2) {
                for (int n3 = 0; n3 < this.Kv; ++n3) {
                    double v1 = (this.Nui.get(u, m2) + this.au) / (this.Nu.get(u) + (double)this.Ku * this.au);
                    double v2 = (this.Nvj.get(v, n3) + this.av) / (this.Nv.get(v) + (double)this.Kv * this.av);
                    double v3 = ((double)this.Nijl[m2][n3][l] + this.bl) / (this.Nij.get(m2, n3) + (double)this.numLevels * this.bl);
                    double prob = v1 * v2 * v3;
                    probs.set(m2, n3, prob);
                    sum += prob;
                }
            }
            probs = probs.scale(1.0 / sum);
            double[] Pu = new double[this.Ku];
            for (m = 0; m < this.Ku; ++m) {
                Pu[m] = probs.sumOfRow(m);
            }
            for (m = 1; m < this.Ku; ++m) {
                int n4 = m;
                Pu[n4] = Pu[n4] + Pu[m - 1];
            }
            double rand = Math.random();
            for (i = 0; i < this.Ku && !(rand < Pu[i]); ++i) {
            }
            double[] Pv = new double[this.Kv];
            for (n = 0; n < this.Kv; ++n) {
                Pv[n] = probs.sumOfColumn(n);
            }
            for (n = 1; n < this.Kv; ++n) {
                int n5 = n;
                Pv[n5] = Pv[n5] + Pv[n - 1];
            }
            rand = Math.random();
            for (j = 0; j < this.Kv && !(rand < Pv[j]); ++j) {
            }
            this.Nui.add(u, i, 1.0);
            this.Nu.add(u, 1.0);
            this.Nvj.add(v, j, 1.0);
            this.Nv.add(v, 1.0);
            int[] nArray2 = this.Nijl[i][j];
            int n6 = l;
            nArray2[n6] = nArray2[n6] + 1;
            this.Nij.add(i, j, 1.0);
            this.Zu.put((Object)u, (Object)v, (Object)i);
            this.Zv.put((Object)u, (Object)v, (Object)j);
        }
    }

    @Override
    protected void readoutParams() {
        int j;
        for (int u = 0; u < this.numUsers; ++u) {
            for (int i = 0; i < this.Ku; ++i) {
                this.PIuSum.add(u, i, (this.Nui.get(u, i) + this.au) / (this.Nu.get(u) + (double)this.Ku * this.au));
            }
        }
        for (int v = 0; v < this.numItems; ++v) {
            for (j = 0; j < this.Kv; ++j) {
                this.PIvSum.add(v, j, (this.Nvj.get(v, j) + this.av) / (this.Nv.get(v) + (double)this.Kv * this.av));
            }
        }
        for (int i = 0; i < this.Ku; ++i) {
            for (j = 0; j < this.Kv; ++j) {
                for (int l = 0; l < this.numLevels; ++l) {
                    double[] dArray = this.PijlSum[i][j];
                    int n = l;
                    dArray[n] = dArray[n] + ((double)this.Nijl[i][j][l] + this.bl) / (this.Nij.get(i, j) + (double)this.numLevels * this.bl);
                }
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.PIu = this.PIuSum.scale(1.0 / (double)this.numStats);
        this.PIv = this.PIvSum.scale(1.0 / (double)this.numStats);
        for (int i = 0; i < this.Ku; ++i) {
            for (int j = 0; j < this.Kv; ++j) {
                for (int l = 0; l < this.numLevels; ++l) {
                    this.Pijl[i][j][l] = this.PijlSum[i][j][l] / (double)this.numStats;
                }
            }
        }
    }

    @Override
    protected boolean isConverged(int iter) throws Exception {
        this.estimateParams();
        int N = 0;
        double sum = 0.0;
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int v = me.column();
            double ruv = me.get();
            sum += this.perplexity(u, v, ruv);
            ++N;
        }
        double perp = Math.exp(sum / (double)N);
        double delta = perp - this.loss;
        if (this.numStats > 1 && delta > 0.0) {
            return true;
        }
        this.loss = perp;
        return false;
    }

    @Override
    protected double perplexity(int u, int v, double pred) throws Exception {
        int l = (int)(pred / this.minRate - 1.0);
        double prob = 0.0;
        for (int i = 0; i < this.Ku; ++i) {
            for (int j = 0; j < this.Kv; ++j) {
                prob += this.Pijl[i][j][l] * this.PIu.get(u, i) * this.PIv.get(v, j);
            }
        }
        return -Math.log(prob);
    }

    @Override
    public double predict(int u, int v) throws Exception {
        double pred = 0.0;
        for (int l = 0; l < this.numLevels; ++l) {
            double rate = (Double)ratingScale.get(l);
            double prob = 0.0;
            for (int i = 0; i < this.Ku; ++i) {
                for (int j = 0; j < this.Kv; ++j) {
                    prob += this.Pijl[i][j][l] * this.PIu.get(u, i) * this.PIv.get(v, j);
                }
            }
            pred += rate * prob;
        }
        return pred;
    }
}

