/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.data.tracking;

import com.recalot.common.Helper;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.interfaces.controller.DataAccessController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.views.common.GenericControllerHandler;
import com.recalot.views.common.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private GenericControllerHandler handler;

    public Servlet(GenericControllerHandler handler) {
        this.handler = handler;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        WebService.processOptionsRequest((HttpServletRequest)req, (HttpServletResponse)res, (String)"POST, OPTIONS");
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[] split;
        String tempKey;
        res.setHeader("Access-Control-Allow-Origin", "*");
        res.setHeader("Access-Control-Allow-Headers", "*");
        String pathInfo = req.getPathInfo();
        TemplateResult result = null;
        HashMap<String, String> params = new HashMap<String, String>();
        Map names = req.getParameterMap();
        if (names != null) {
            for (Object key : names.keySet()) {
                params.put(URLDecoder.decode((String)key, "UTF-8"), URLDecoder.decode(req.getParameter((String)key), "UTF-8"));
            }
        }
        String templateKey = "json";
        if (params.containsKey(Helper.Keys.OutputParam) && (tempKey = (String)params.get(Helper.Keys.OutputParam)) != null && !tempKey.equals("")) {
            templateKey = tempKey;
        }
        if (pathInfo != null && !pathInfo.equals("") && pathInfo.length() > 1 && (split = pathInfo.substring(1).split("\\/")).length >= 6 && split[0].toLowerCase().equals("sources") && split[2].toLowerCase().equals("users") && split[4].toLowerCase().equals("items")) {
            String sourceId = split[1];
            String userId = split[3];
            String itemId = split[5];
            if (!(userId == null || userId.trim().equals("") || itemId == null || itemId.trim().equals("") || templateKey == null || templateKey.trim().equals(""))) {
                params.put(Helper.Keys.SourceId, sourceId);
                params.put(Helper.Keys.ItemId, itemId);
                params.put(Helper.Keys.UserId, userId);
                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.AddInteraction, templateKey, params);
            }
        }
        if (result != null) {
            res.setContentType(result.getContentType());
            res.setCharacterEncoding(result.getCharset().name());
            res.setStatus(result.getStatus());
            PrintWriter out = res.getWriter();
            Helper.copy((PrintWriter)out, (InputStream)result.getResult());
        }
    }
}

