/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common;

import com.recalot.common.NamedThreadFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Parallel {
    private static final int NUM_CORES = Runtime.getRuntime().availableProcessors() > 2 ? Runtime.getRuntime().availableProcessors() - 2 : 1;
    private static final ExecutorService forPool = Executors.newFixedThreadPool(NUM_CORES * 2, new NamedThreadFactory("Parallel.For"));

    public static <T> void For(Iterable<T> elements, Operation<T> operation) {
        try {
            forPool.invokeAll(Parallel.createCallables(elements, operation));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static <T> Collection<Callable<Void>> createCallables(Iterable<T> elements, Operation<T> operation) {
        LinkedList<Callable<Void>> callables = new LinkedList<Callable<Void>>();
        for (Object elem : elements) {
            callables.add(() -> {
                operation.perform(elem);
                return null;
            });
        }
        return callables;
    }

    public static interface Operation<T> {
        public void perform(T var1);
    }
}

