/*
 * Decompiled with CFR 0.152.
 */
package flexjson.locators;

import flexjson.ClassLocator;
import flexjson.JSONException;
import flexjson.ObjectBinder;
import flexjson.Path;
import java.util.HashMap;
import java.util.Map;

public class TypeLocator<T>
implements ClassLocator {
    private String fieldname;
    private Map<T, Class> types = new HashMap<T, Class>();

    public TypeLocator(String fieldname) {
        this.fieldname = fieldname;
    }

    public TypeLocator add(T value, Class type) {
        this.types.put(value, type);
        return this;
    }

    @Override
    public Class locate(ObjectBinder context, Path currentPath) throws ClassNotFoundException {
        Object source = context.getSource();
        if (source instanceof Map) {
            Map map = (Map)source;
            return this.types.get(map.get(this.fieldname));
        }
        throw new JSONException(String.format("%s: Don't know how to locate types for source %s using fieldname %s.  TypeLocator requires the source object be a java.util.Map in order to work.", context.getCurrentPath(), source.getClass(), this.fieldname));
    }
}

