/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.bprmf;

import com.recalot.common.Helper;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.model.rec.recommender.bprmf.DataManagement;
import com.recalot.model.rec.recommender.funksvd.helper.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

@Configurations(value={@Configuration(key="uniformUserSampling", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="biasReg", type=ConfigurationItem.ConfigurationItemType.Double, value="0", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="numFeatures", type=ConfigurationItem.ConfigurationItemType.Integer, value="100", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="initialSteps", type=ConfigurationItem.ConfigurationItemType.Integer, value="100", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="learnRate", type=ConfigurationItem.ConfigurationItemType.Double, value="0.05", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="regU", type=ConfigurationItem.ConfigurationItemType.Double, value="0.0025", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="regI", type=ConfigurationItem.ConfigurationItemType.Double, value="0.0025", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="regJ", type=ConfigurationItem.ConfigurationItemType.Double, value="0.00025", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="updateJ", type=ConfigurationItem.ConfigurationItemType.Boolean, value="true", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)})
public class BPRMFRecommender
extends Recommender {
    public boolean uniformUserSampling = true;
    private static final Random random = RandomUtils.getRandom();
    public double biasReg = 0.0;
    public int numFeatures = 100;
    public int initialSteps = 100;
    protected int numUsers;
    public int numItems;
    public DataManagement data = new DataManagement();
    public double learnRate = 0.05;
    public double regU = 0.0025;
    public double regI = 0.0025;
    public double regJ = 2.5E-4;
    public boolean updateJ = true;

    public BPRMFRecommender() {
        this.setKey("bprmf");
    }

    public double predictRatingBPR(String userId, String itemId) {
        long start = System.currentTimeMillis();
        int itemidx = this.data.itemIndices.get(itemId);
        Integer useridx = this.data.userIndices.get(userId);
        if (useridx != null) {
            long end = System.currentTimeMillis();
            return (float)(this.data.item_bias[itemidx] + this.data.rowScalarProduct(useridx, itemidx));
        }
        return Double.NaN;
    }

    public void train() throws BaseException {
        try {
            this.numItems = this.getDataSet().getItemsCount();
            this.numUsers = this.getDataSet().getUsersCount();
            this.data.init(this.getDataSet(), this.numUsers, this.numItems, this.numFeatures);
            for (int i = 0; i < this.initialSteps; ++i) {
                this.iterate();
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        List<RecommendedItem> items = new ArrayList();
        try {
            List rec = this.recommendItemsByRatingPrediction(userId, true);
            for (String key : rec) {
                items.add(new RecommendedItem(key, 0.0));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        items = Helper.applySubList(items, param, (int)10);
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return this.predictRatingBPR(userId.toLowerCase(), itemId.toLowerCase());
    }

    public void iterate() {
        int num_pos_events = this.data.numPosentries;
        if (this.uniformUserSampling) {
            for (int i = 0; i < num_pos_events; ++i) {
                int[] triple = this.sampleTriple();
                int user_id = triple[0];
                int pos_item_id = triple[1];
                int neg_item_id = triple[2];
                this.updateFactors(user_id, pos_item_id, neg_item_id, true, true, this.updateJ);
            }
        } else {
            for (int k = 0; k < this.data.boolMatrix_numUsers; ++k) {
                for (int l = 0; l < this.data.boolMatrix_numItems; ++l) {
                    int user_id = k;
                    int pos_item_id = l;
                    int neg_item_id = -1;
                    if (!this.data.boolMatrix.getBool(user_id, pos_item_id)) continue;
                    int[] sampleTriple = this.sampleOtheritem(user_id, pos_item_id, neg_item_id);
                    user_id = sampleTriple[0];
                    pos_item_id = sampleTriple[1];
                    neg_item_id = sampleTriple[2];
                    this.updateFactors(user_id, pos_item_id, neg_item_id, true, true, this.updateJ);
                }
            }
        }
    }

    public void updateFactors(int u, int i, int j, boolean update_u, boolean update_i, boolean update_j) {
        double update;
        double x_uij = this.data.item_bias[i] - this.data.item_bias[j] + this.data.rowScalarProductWithRowDifference(u, i, j);
        double one_over_one_plus_ex = 1.0 / (1.0 + Math.exp(x_uij));
        if (update_i) {
            update = one_over_one_plus_ex - this.biasReg * this.data.item_bias[i];
            int n = i;
            this.data.item_bias[n] = this.data.item_bias[n] + this.learnRate * update;
        }
        if (update_j) {
            update = -one_over_one_plus_ex - this.biasReg * this.data.item_bias[j];
            int n = j;
            this.data.item_bias[n] = this.data.item_bias[n] + this.learnRate * update;
        }
        for (int f = 0; f < this.numFeatures; ++f) {
            double update2;
            double w_uf = this.data.latentUserVector[u][f];
            double h_if = this.data.latentItemVector[i][f];
            double h_jf = this.data.latentItemVector[j][f];
            if (update_u) {
                update2 = (h_if - h_jf) * one_over_one_plus_ex - this.regU * w_uf;
                this.data.latentUserVector[u][f] = w_uf + this.learnRate * update2;
            }
            if (update_i) {
                update2 = w_uf * one_over_one_plus_ex - this.regI * h_if;
                this.data.latentItemVector[i][f] = (float)(h_if + this.learnRate * update2);
            }
            if (!update_j) continue;
            update2 = -w_uf * one_over_one_plus_ex - this.regJ * h_jf;
            this.data.latentItemVector[j][f] = (float)(h_jf + this.learnRate * update2);
        }
    }

    public int[] sampleOtheritem(int u, int i, int j) {
        int[] sampleTriple = new int[]{u, i, j};
        boolean item_is_positive = this.data.boolMatrix.getBool(u, i);
        do {
            sampleTriple[2] = random.nextInt(this.numItems);
        } while (this.data.boolMatrix.getBool(u, sampleTriple[2]) == item_is_positive);
        return sampleTriple;
    }

    public int sampleUser() {
        List viewedItemsList;
        int u;
        while (!this.data.userMatrix.containsKey(u = random.nextInt(this.numUsers)) || (viewedItemsList = (List)this.data.userMatrix.get(u)) == null || viewedItemsList.size() == 0 || viewedItemsList.size() == this.numItems) {
        }
        return u;
    }

    public int[] sampleTriple() {
        int[] triple = new int[3];
        triple[0] = this.sampleUser();
        return this.sampleItempair(triple);
    }

    public int[] sampleItempair(int[] triple) {
        int u = triple[0];
        List user_items = this.data.userMatrix.get(u);
        triple[1] = (Integer)user_items.get(random.nextInt(user_items.size()));
        do {
            triple[2] = random.nextInt(this.numItems);
        } while (user_items.contains(triple[2]));
        return triple;
    }

    public void setNumFeatures(int n) {
        this.numFeatures = n;
    }

    public void setRegI(double n) {
        this.regI = n;
    }

    public void setRegJ(double n) {
        this.regJ = n;
    }

    public void setRegU(double n) {
        this.regU = n;
    }

    public void setUpdateJ(boolean n) {
        this.updateJ = n;
    }

    public void setBiasReg(double n) {
        this.biasReg = n;
    }

    public void setLearnRate(double n) {
        this.learnRate = n;
    }

    public void setInitialSteps(int n) {
        this.initialSteps = n;
    }

    public void setUniformSampling(boolean n) {
        this.uniformUserSampling = n;
    }

    public void setUseRelevanceThreshold(boolean u) throws Exception {
        this.data.useRatingThreshold = u;
    }
}

