/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.bprmf;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.recommender.funksvd.helper.RandomUtils;
import com.recalot.model.rec.recommender.helper.matrix.SparseByteMatrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;

public class DataManagement {
    public HashMap<Integer, String> userMap;
    public HashMap<Integer, String> itemMap;
    public HashMap<String, Integer> userIndices;
    public HashMap<String, Integer> itemIndices;
    public double[] item_bias;
    public int userid;
    public int itemid;
    public static double sqrt_e_div_2_pi = Math.sqrt(0.43262798971613253);
    public static final Random random = RandomUtils.getRandom();
    private double initMean = 0.0;
    private double initStDev = 0.1;
    public double[][] latentUserVector;
    public double[][] latentItemVector;
    public HashMap<Integer, ArrayList<Integer>> userMatrix;
    SparseByteMatrix boolMatrix;
    int boolMatrix_numUsers;
    int boolMatrix_numItems;
    public int numPosentries;
    public DataSet dataSet;
    public boolean useRatingThreshold = false;

    public void init(DataSet dataSet, int numUsers, int numItems, int numFeatures) throws BaseException {
        this.dataSet = dataSet;
        this.userMap = new HashMap();
        this.itemMap = new HashMap();
        this.userIndices = new HashMap();
        this.itemIndices = new HashMap();
        this.userid = 0;
        this.itemid = 0;
        this.numPosentries = 0;
        this.userMatrix = new HashMap();
        for (User user : dataSet.getUsers()) {
            this.addUser(user);
        }
        for (User user : dataSet.getItems()) {
            this.addItem((Item)user);
        }
        this.latentUserVector = new double[numUsers][numFeatures];
        this.latentItemVector = new double[numItems][numFeatures];
        this.initLatentmatrix(this.latentUserVector);
        this.initLatentmatrix(this.latentItemVector);
        this.item_bias = new double[numItems];
        this.boolMatrix = new SparseByteMatrix(numUsers, numItems);
        this.boolMatrix_numUsers = numUsers;
        this.boolMatrix_numItems = numItems;
        this.booleanRatings();
    }

    public void booleanRatings() throws BaseException {
        for (Interaction r : this.dataSet.getInteractions()) {
            Integer user = this.userIndices.get(r.getUserId().toLowerCase());
            Integer item = this.itemIndices.get(r.getItemId().toLowerCase());
            try {
                this.boolMatrix.setBool(user, item, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList<Integer> ratingsOfUser = this.userMatrix.get(user);
            if (ratingsOfUser == null) {
                ratingsOfUser = new ArrayList();
                this.userMatrix.put(user, ratingsOfUser);
            }
            ratingsOfUser.add(item);
            ++this.numPosentries;
        }
    }

    private void initLatentmatrix(double[][] matrix) {
        for (int k = 0; k < matrix.length; ++k) {
            for (int l = 0; l < matrix[k].length; ++l) {
                matrix[k][l] = this.nextNormal(this.initMean, this.initStDev);
            }
        }
    }

    public double rowScalarProductWithRowDifference(int user, int item1, int item2) {
        if (user >= this.latentUserVector.length) {
            throw new IllegalArgumentException("i too big: " + user + ", dim1 is " + this.latentUserVector.length);
        }
        if (item1 >= this.latentItemVector.length) {
            throw new IllegalArgumentException("item1 too big: " + item1 + ", dim1 is " + this.latentItemVector.length);
        }
        if (item2 >= this.latentItemVector.length) {
            throw new IllegalArgumentException("j too big: " + item2 + ", dim1 is " + this.latentItemVector.length);
        }
        if (this.latentUserVector[user].length != this.latentItemVector[item1].length) {
            throw new IllegalArgumentException("wrong row size: " + this.latentUserVector[user].length + " vs. " + this.latentItemVector[item1].length);
        }
        if (this.latentUserVector[user].length != this.latentItemVector[item2].length) {
            throw new IllegalArgumentException("wrong row size: " + this.latentUserVector[user].length + " vs. " + this.latentItemVector[item2].length);
        }
        double result = 0.0;
        for (int c = 0; c < this.latentUserVector[user].length; ++c) {
            result += this.latentUserVector[user][c] * (Double.valueOf(this.latentItemVector[item1][c]) - Double.valueOf(this.latentItemVector[item2][c]));
        }
        return result;
    }

    public double rowScalarProduct(int user, int item) {
        if (user >= this.latentUserVector.length) {
            throw new IllegalArgumentException("i too big: " + user + ", dim1 is " + this.latentUserVector.length);
        }
        if (item >= this.latentItemVector.length) {
            throw new IllegalArgumentException("j too big: " + item + ", dim1 is " + this.latentItemVector.length);
        }
        if (this.latentUserVector[user].length != this.latentItemVector[item].length) {
            throw new IllegalArgumentException("wrong row size: " + this.latentUserVector[user].length + " vs. " + this.latentItemVector[item].length);
        }
        Double result = 0.0;
        for (int c = 0; c < this.latentUserVector[user].length; ++c) {
            result = result + Double.valueOf(this.latentUserVector[user][c]) * Double.valueOf(this.latentItemVector[item][c]);
        }
        return result;
    }

    public void addUser(User user) {
        this.userMap.put(this.userid, user.getId().toLowerCase());
        this.userIndices.put(user.getId().toLowerCase(), this.userid);
        ++this.userid;
    }

    public void addItem(Item item) {
        this.itemMap.put(this.itemid, item.getId().toLowerCase());
        this.itemIndices.put(item.getId().toLowerCase(), this.itemid);
        ++this.itemid;
    }

    public double nextNormal(double mean, double stdev) {
        return mean + stdev * this.nextNormal();
    }

    public double nextNormal() {
        double x;
        double u;
        double y;
        while ((y = 2.0 * (u = random.nextDouble()) * sqrt_e_div_2_pi * Math.exp(-(x = this.nextExp(1.0)))) < 0.3183098861837907 * Math.exp(-0.5 * x * x)) {
        }
        if (random.nextDouble() < 0.5) {
            return x;
        }
        return -x;
    }

    public double nextExp(double lambda) {
        double u = random.nextDouble();
        return -(1.0 / lambda) * Math.log(1.0 - u);
    }
}

