/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.funksvd.helper;

import com.recalot.model.rec.recommender.funksvd.helper.RandomUtils;
import java.util.Random;

public final class GradientDescentSVD {
    private static final Random random = RandomUtils.getRandom();
    private static final double LEARNING_RATE = 0.005;
    private static final double K = 0.02;
    private static final double r = 0.005;
    private final int m;
    private final int n;
    private final int k;
    private final double[][] leftVector;
    private final double[][] rightVector;

    public GradientDescentSVD(int m, int n, int k, double defaultValue) {
        this(m, n, k, defaultValue, 0.005);
    }

    public GradientDescentSVD(int m, int n, int k, double defaultValue, double noise) {
        this.m = m;
        this.n = n;
        this.k = k;
        this.leftVector = new double[m][k];
        this.rightVector = new double[n][k];
        for (int i = 0; i < k; ++i) {
            int j;
            for (j = 0; j < m; ++j) {
                this.leftVector[j][i] = defaultValue + (random.nextDouble() - 0.5) * noise;
            }
            for (j = 0; j < n; ++j) {
                this.rightVector[j][i] = defaultValue + (random.nextDouble() - 0.5) * noise;
            }
        }
    }

    public double getDotProduct(int i, int j) {
        double result = 1.0;
        double[] leftVectorI = this.leftVector[i];
        double[] rightVectorJ = this.rightVector[j];
        for (int k = 0; k < this.k; ++k) {
            result += leftVectorI[k] * rightVectorJ[k];
        }
        return result;
    }

    public void train(int i, int j, int k, double value) {
        double err = value - this.getDotProduct(i, j);
        double[] leftVectorI = this.leftVector[i];
        double[] rightVectorJ = this.rightVector[j];
        int n = k;
        leftVectorI[n] = leftVectorI[n] + 0.005 * (err * rightVectorJ[k] - 0.02 * leftVectorI[k]);
        int n2 = k;
        rightVectorJ[n2] = rightVectorJ[n2] + 0.005 * (err * leftVectorI[k] - 0.02 * rightVectorJ[k]);
    }

    int getM() {
        return this.m;
    }

    int getN() {
        return this.n;
    }

    int getK() {
        return this.k;
    }

    public double[] getLeftVector(int user) {
        return this.leftVector[user];
    }
}

