/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.funksvd.helper;

import com.recalot.model.rec.recommender.funksvd.helper.RandomWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;

public final class RandomUtils {
    public static final int MAX_INT_SMALLER_TWIN_PRIME = 2147482949;
    private static final Map<RandomWrapper, Boolean> instances = Collections.synchronizedMap(new WeakHashMap());

    private RandomUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useTestSeed() {
        RandomWrapper.useTestSeed();
        Map<RandomWrapper, Boolean> map = instances;
        synchronized (map) {
            for (RandomWrapper rng : instances.keySet()) {
                rng.reset();
            }
        }
    }

    public static Random getRandom() {
        RandomWrapper random = new RandomWrapper();
        instances.put(random, Boolean.TRUE);
        return random;
    }

    public static Random getRandom(long seed) {
        RandomWrapper random = new RandomWrapper(seed);
        instances.put(random, Boolean.TRUE);
        return random;
    }

    public static byte[] longSeedtoBytes(long seed) {
        byte[] seedBytes = new byte[16];
        seedBytes[0] = (byte)(seed >>> 56);
        seedBytes[1] = (byte)(seed >>> 48);
        seedBytes[2] = (byte)(seed >>> 40);
        seedBytes[3] = (byte)(seed >>> 32);
        seedBytes[4] = (byte)(seed >>> 24);
        seedBytes[5] = (byte)(seed >>> 16);
        seedBytes[6] = (byte)(seed >>> 8);
        seedBytes[7] = (byte)seed;
        System.arraycopy(seedBytes, 0, seedBytes, 8, 8);
        return seedBytes;
    }

    public static long seedBytesToLong(byte[] seed) {
        return ((long)seed[0] & 0xFFL) << 56 | ((long)seed[1] & 0xFFL) << 48 | ((long)seed[2] & 0xFFL) << 40 | ((long)seed[3] & 0xFFL) << 32 | ((long)seed[4] & 0xFFL) << 24 | ((long)seed[5] & 0xFFL) << 16 | ((long)seed[6] & 0xFFL) << 8 | (long)seed[7] & 0xFFL;
    }

    public static int hashDouble(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int hashFloat(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashLong(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int nextTwinPrime(int n) {
        if (n > 2147482949) {
            throw new IllegalArgumentException();
        }
        if (n <= 3) {
            return 3;
        }
        int next = RandomUtils.nextPrime(n);
        while (RandomUtils.isNotPrime(next + 2)) {
            next = RandomUtils.nextPrime(next + 4);
        }
        return next + 2;
    }

    public static int nextPrime(int n) {
        if (n < 2) {
            return 2;
        }
        n |= 1;
        while (RandomUtils.isNotPrime(n)) {
            n += 2;
        }
        return n;
    }

    public static boolean isNotPrime(int n) {
        if (n < 2 || (n & 1) == 0) {
            return true;
        }
        int max = 1 + (int)Math.sqrt(n);
        for (int d = 3; d <= max; d += 2) {
            if (n % d != 0) continue;
            return true;
        }
        return false;
    }
}

