/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.helper.matrix;

import com.recalot.model.rec.recommender.helper.matrix.SparseMatrix;
import gnu.trove.map.TIntByteMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntByteHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntByteProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import java.io.Serializable;

public class SparseByteMatrix
implements Serializable,
SparseMatrix<Byte> {
    private static final long serialVersionUID = -1968296592755890929L;
    TIntObjectMap<TIntByteMap> matrix = new TIntObjectHashMap<TIntByteMap>();
    private int M;
    private int N;
    private int numberOfEntries;

    public SparseByteMatrix() {
        this.numberOfEntries = 0;
    }

    public SparseByteMatrix(int m, int n) {
        this.M = m;
        this.N = n;
        this.numberOfEntries = 0;
    }

    @Override
    public void set(int i, int j, Byte b) {
        TIntByteMap row = this.matrix.get(i);
        if (row == null) {
            if (b == 0) {
                return;
            }
            row = new TIntByteHashMap();
            this.matrix.put(i, row);
        }
        if (b == 0) {
            if (row.get(j) == 0) {
                return;
            }
            row.remove(j);
            --this.numberOfEntries;
        } else {
            row.put(j, b);
            ++this.numberOfEntries;
        }
    }

    @Override
    public void setBool(int i, int j, boolean b) {
        if (b) {
            this.set(i, j, (byte)1);
        } else {
            this.set(i, j, (byte)0);
        }
    }

    @Override
    public Byte get(int i, int j) {
        TIntByteMap row = this.matrix.get(i);
        if (row != null) {
            byte value = row.get(j);
            return value;
        }
        return (byte)0;
    }

    @Override
    public boolean getBool(int i, int j) {
        TIntByteMap row = this.matrix.get(i);
        if (row != null) {
            byte value = row.get(j);
            return value != 0;
        }
        return false;
    }

    @Override
    public TIntByteMap getRow(int i) {
        return this.matrix.get(i);
    }

    public SparseByteMatrix copy() {
        SparseByteMatrix copy = new SparseByteMatrix();
        OuterRunner outerRunner = new OuterRunner(copy);
        this.matrix.forEachEntry(outerRunner);
        return copy;
    }

    @Override
    public int getM() {
        return this.M;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public String getType() {
        return "byte";
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    private class InnerRunner
    implements TIntByteProcedure {
        SparseByteMatrix copy;
        int i;

        InnerRunner(SparseByteMatrix copy, int i) {
            this.copy = copy;
            this.i = i;
        }

        @Override
        public boolean execute(int j, byte b) {
            this.copy.set(this.i, j, b);
            return true;
        }
    }

    private class OuterRunner
    implements TIntObjectProcedure<TIntByteMap> {
        SparseByteMatrix copy;

        OuterRunner(SparseByteMatrix copy) {
            this.copy = copy;
        }

        @Override
        public boolean execute(int i, TIntByteMap row) {
            InnerRunner innerRunner = new InnerRunner(this.copy, i);
            return row.forEachEntry(innerRunner);
        }
    }
}

