/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.helper.matrix;

import com.recalot.model.rec.recommender.helper.matrix.SparseMatrix;
import gnu.trove.map.TIntDoubleMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntDoubleHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntDoubleProcedure;
import gnu.trove.procedure.TIntObjectProcedure;
import java.io.Serializable;

public class SparseDoubleMatrix
implements Serializable,
SparseMatrix<Double> {
    private static final long serialVersionUID = 5094000563236604468L;
    TIntObjectMap<TIntDoubleMap> matrix = new TIntObjectHashMap<TIntDoubleMap>();
    private int M;
    private int N;
    private int numberOfEntries;

    public SparseDoubleMatrix() {
        this.numberOfEntries = 0;
    }

    public SparseDoubleMatrix(int m, int n) {
        this.M = m;
        this.N = n;
        this.numberOfEntries = 0;
    }

    @Override
    public void set(int i, int j, Double b) {
        TIntDoubleMap row = this.matrix.get(i);
        if (row == null) {
            if (b == 0.0) {
                return;
            }
            row = new TIntDoubleHashMap();
            this.matrix.put(i, row);
        }
        if (b == 0.0) {
            if (row.get(j) == 0.0) {
                return;
            }
            row.remove(j);
            --this.numberOfEntries;
        } else {
            row.put(j, b);
            ++this.numberOfEntries;
        }
    }

    @Override
    public void setBool(int i, int j, boolean b) {
        if (b) {
            this.set(i, j, 1.0);
        } else {
            this.set(i, j, 0.0);
        }
    }

    @Override
    public Double get(int i, int j) {
        TIntDoubleMap row = this.matrix.get(i);
        if (row != null) {
            double value = row.get(j);
            return value;
        }
        return 0.0;
    }

    @Override
    public boolean getBool(int i, int j) {
        TIntDoubleMap row = this.matrix.get(i);
        if (row != null) {
            double value = row.get(j);
            return value != 0.0;
        }
        return false;
    }

    @Override
    public TIntDoubleMap getRow(int i) {
        return this.matrix.get(i);
    }

    public SparseDoubleMatrix copy() {
        SparseDoubleMatrix copy = new SparseDoubleMatrix();
        OuterRunner outerRunner = new OuterRunner(copy);
        this.matrix.forEachEntry(outerRunner);
        return copy;
    }

    @Override
    public int getM() {
        return this.M;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public String getType() {
        return "double";
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    private class InnerRunner
    implements TIntDoubleProcedure {
        SparseDoubleMatrix copy;
        int i;

        InnerRunner(SparseDoubleMatrix copy, int i) {
            this.copy = copy;
            this.i = i;
        }

        @Override
        public boolean execute(int j, double b) {
            this.copy.set(this.i, j, b);
            return true;
        }
    }

    private class OuterRunner
    implements TIntObjectProcedure<TIntDoubleMap> {
        SparseDoubleMatrix copy;

        OuterRunner(SparseDoubleMatrix copy) {
            this.copy = copy;
        }

        @Override
        public boolean execute(int i, TIntDoubleMap row) {
            InnerRunner innerRunner = new InnerRunner(this.copy, i);
            return row.forEachEntry(innerRunner);
        }
    }
}

