/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.knn;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Configurations(value={@Configuration(key="minOverlap", type=ConfigurationItem.ConfigurationItemType.Integer, value="3", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="maxNeighbors", type=ConfigurationItem.ConfigurationItemType.Integer, value="10", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional), @Configuration(key="minSimilarity", type=ConfigurationItem.ConfigurationItemType.Integer, value="0.0", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional)})
public class UserBasedCosineNearestNeighborsRecommender
extends Recommender {
    private Integer minOverlap = 1;
    private Integer maxNeighbors = 10;
    private Double minSimilarity = 0.0;
    private HashMap<String, List<Integer>> userVectors;
    private HashMap<String, Integer> itemPosInVector;
    private LinkedHashMap<String, Map<String, Double>> similarityies;

    public UserBasedCosineNearestNeighborsRecommender() {
        this.setKey("cosine-user-knn");
    }

    public void train() throws BaseException {
        this.userVectors = new HashMap();
        ArrayList<Integer> emptyVector = new ArrayList<Integer>();
        this.itemPosInVector = new HashMap();
        int i = 0;
        for (Item item : this.getDataSet().getItems()) {
            emptyVector.add(0);
            this.itemPosInVector.put(item.getId(), i++);
        }
        for (Item item : this.getDataSet().getUsers()) {
            this.userVectors.put(item.getId(), new ArrayList(emptyVector));
        }
        for (Item item : this.getDataSet().getInteractions()) {
            String userId = item.getUserId();
            String itemId = item.getItemId();
            if (!this.userVectors.containsKey(userId) || !this.itemPosInVector.containsKey(itemId)) continue;
            int pos = this.itemPosInVector.get(itemId);
            if (item.getValue() != null && !item.getValue().isEmpty()) {
                int value = Integer.parseInt(item.getValue());
                this.userVectors.get(userId).set(pos, value);
                continue;
            }
            this.userVectors.get(userId).set(pos, 1);
        }
        this.similarityies = new LinkedHashMap();
        for (Item item : this.getDataSet().getUsers()) {
            LinkedHashMap<String, Double> similarity = new LinkedHashMap<String, Double>();
            for (User user2 : this.getDataSet().getUsers()) {
                List<Integer> v2;
                List<Integer> v1;
                if (item.getId().equals(user2.getId()) || !this.userVectors.containsKey(item.getId()) || !this.userVectors.containsKey(user2.getId()) || Helper.getOverlapping(v1 = this.userVectors.get(item.getId()), v2 = this.userVectors.get(user2.getId())) <= this.minOverlap) continue;
                similarity.put(user2.getId(), Helper.computeCosSimilarity(v1, v2));
            }
            this.similarityies.put(item.getId(), Helper.sortByValueDescending(similarity));
        }
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return 0.0;
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>();
        double maxValue = 0.0;
        if (this.similarityies != null && this.similarityies.containsKey(userId)) {
            Map<String, Double> sim = this.similarityies.get(userId);
            int i = 0;
            LinkedHashMap sumSim = new LinkedHashMap();
            Map ratingsItems = new LinkedHashMap();
            for (String key : sim.keySet()) {
                double simUser = sim.get(key);
                try {
                    Interaction[] interactions = this.getDataSet().getInteractions(key);
                    if (interactions != null) {
                        for (Interaction interaction : interactions) {
                            double value = Double.parseDouble(interaction.getValue());
                            if (value > maxValue) {
                                maxValue = value;
                            }
                            Helper.incrementMapValue(ratingsItems, (Object)interaction.getItemId(), (Double)(value * simUser));
                            Helper.incrementMapValue(sumSim, (Object)interaction.getItemId(), (Double)simUser);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i++ < this.maxNeighbors) continue;
                break;
            }
            ratingsItems = Helper.sortByValueDescending(ratingsItems);
            int count = Integer.MAX_VALUE;
            if (param != null && param.containsKey("count")) {
                count = Integer.parseInt(param.get("count"));
            }
            i = 0;
            for (String itemId : ratingsItems.keySet()) {
                result.add(new RecommendedItem(itemId, (Double)ratingsItems.get(itemId) / (Double)sumSim.get(itemId) / maxValue));
                if (i++ < count) continue;
                break;
            }
        }
        return new RecommendationResult(this.getId(), result);
    }

    public Integer getMinOverlap() {
        return this.minOverlap;
    }

    public void setMinOverlap(Integer minOverlap) {
        this.minOverlap = minOverlap;
    }

    public Integer getMaxNeighbors() {
        return this.maxNeighbors;
    }

    public void setMaxNeighbors(Integer maxNeighbors) {
        this.maxNeighbors = maxNeighbors;
    }

    public Double getMinSimilarity() {
        return this.minSimilarity;
    }

    public void setMinSimilarity(Double minSimilarity) {
        this.minSimilarity = minSimilarity;
    }
}

