/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common;

import com.recalot.common.communication.RecommendedItem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Helper {
    public static void copy(PrintWriter out, InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        char[] buffer = new char[1024];
        int len = reader.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = reader.read(buffer);
        }
        reader.close();
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValueDescending(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o2.getValue()).compareTo(o1.getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static void showMap(Map<String, Map<String, Double>> map) {
        System.out.println("[");
        for (Map.Entry<String, Map<String, Double>> e : map.entrySet()) {
            System.out.println("Outer Key: " + e.getKey());
            for (Map.Entry<String, Double> inner : e.getValue().entrySet()) {
                System.out.println("... " + inner.getKey() + ": " + inner.getValue());
            }
        }
        System.out.println("]");
    }

    public static void showMap(Map<String, Map<String, Double>> map, int innercap) {
        int outercap = map.size();
        Helper.showMap(map, outercap, innercap);
    }

    public static void showMap(Map<String, Map<String, Double>> map, int outercap, int innercap) {
        int counterouter = 0;
        int counterinner = 0;
        System.out.println("[");
        for (Map.Entry<String, Map<String, Double>> e : map.entrySet()) {
            ++counterouter;
            System.out.println("Outer Key: " + e.getKey());
            for (Map.Entry<String, Double> inner : e.getValue().entrySet()) {
                System.out.println("... " + inner.getKey() + ": " + inner.getValue());
                if (++counterinner < innercap) continue;
                counterinner = 0;
                break;
            }
            if (counterouter < outercap) continue;
            counterouter = 0;
            break;
        }
        System.out.println("]");
    }

    public static void showItems(List<RecommendedItem> itemlist) {
        System.out.println("[");
        for (RecommendedItem item : itemlist) {
            System.out.print(item.getItemId() + ", ");
        }
        System.out.println("\n]");
    }

    public static Map<String, Map<String, Double>> swapMap(Map<String, Map<String, Double>> map) {
        LinkedHashMap<String, Map<String, Double>> result = new LinkedHashMap<String, Map<String, Double>>();
        if (map != null) {
            for (Map.Entry<String, Map<String, Double>> e : map.entrySet()) {
                String innerkey = e.getKey();
                for (Map.Entry<String, Double> inner : e.getValue().entrySet()) {
                    String outerkey = inner.getKey();
                    if (!result.containsKey(outerkey)) {
                        result.put(outerkey, new LinkedHashMap());
                    }
                    ((Map)result.get(outerkey)).put(innerkey, inner.getValue());
                }
            }
        }
        return result;
    }

    public static <K> void incrementMapValue(Map<K, Integer> map, K key) {
        Integer existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, 1);
        } else {
            map.put(key, existingValue + 1);
        }
    }

    public static <K> void incrementMapValue(Map<K, Integer> map, K key, Integer value) {
        Integer existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, value);
        } else {
            map.put(key, existingValue + value);
        }
    }

    public static <K> void incrementMapValue(Map<K, Double> map, K key, Double value) {
        Double existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, value);
        } else {
            map.put(key, existingValue + value);
        }
    }

    public static <K> Integer sum(Map<K, Integer> map) {
        Integer sum = 0;
        for (Integer v : map.values()) {
            sum = sum + v;
        }
        return sum;
    }

    public static Double computeCosSimilarity(List<Integer> v1, List<Integer> v2) {
        if (v1.size() != v2.size()) {
            return 0.0;
        }
        Double a = 0.0;
        Double b = 0.0;
        Double c = 0.0;
        for (int i = 0; i < v1.size(); ++i) {
            a = a + (double)(v1.get(i) * v2.get(i));
            b = b + (double)(v1.get(i) * v1.get(i));
            c = c + (double)(v2.get(i) * v2.get(i));
        }
        if (b > 0.0 && c > 0.0) {
            return a / (Math.sqrt(b) * Math.sqrt(c));
        }
        return 0.0;
    }

    public static Double computePearsonSimilarity(List<Integer> v1, List<Integer> v2) {
        Double result = 0.0;
        int size = v1.size();
        if (v1.size() == v2.size()) {
            Double xy = 0.0;
            Double v1sum = 0.0;
            Double v2sum = 0.0;
            Double xx = 0.0;
            Double yy = 0.0;
            for (int i = 0; i < size; ++i) {
                int xi = v1.get(i);
                int yi = v2.get(i);
                xy = xy + (double)(xi * yi);
                v1sum = v1sum + (double)xi;
                v2sum = v2sum + (double)yi;
                xx = xx + (double)(xi * xi);
                yy = yy + (double)(yi * yi);
            }
            Double a = (double)size * xy;
            Double b = v1sum * v2sum;
            Double c = (double)size * xx - v1sum * v1sum;
            Double d = (double)size * yy - v2sum * v2sum;
            if (c * d > 0.0) {
                result = (a - b) / (Math.sqrt(c) * Math.sqrt(d));
            }
        }
        return result;
    }

    public static Double computeAdjustedCosineSimilarity(List<Integer> v1, List<Integer> v2) {
        Double result = 0.0;
        Double sumv1 = 0.0;
        Double sumv2 = 0.0;
        Double mean1 = 0.0;
        Double mean2 = 0.0;
        int size = v1.size();
        if (v1.size() == v2.size()) {
            for (int i = 0; i < size; ++i) {
                sumv1 = sumv1 + (double)v1.get(i).intValue();
                sumv2 = sumv2 + (double)v2.get(i).intValue();
            }
            mean1 = sumv1 / (double)size;
            mean2 = sumv2 / (double)size;
            result = Helper.computeAdjustedCosineSimilarity(v1, v2, mean1, mean2);
        }
        return result;
    }

    public static Double computeAdjustedCosineSimilarityDoubles(List<Double> v1, List<Double> v2) {
        Double result = 0.0;
        Double sumv1 = 0.0;
        Double sumv2 = 0.0;
        Double mean1 = 0.0;
        Double mean2 = 0.0;
        int size = v1.size();
        if (v1.size() == v2.size()) {
            for (int i = 0; i < size; ++i) {
                sumv1 = sumv1 + v1.get(i);
                sumv2 = sumv2 + v2.get(i);
            }
            mean1 = sumv1 / (double)size;
            mean2 = sumv2 / (double)size;
            result = Helper.computeAdjustedCosineSimilarityDoubles(v1, v2, mean1, mean2);
        }
        return result;
    }

    public static Double computeAdjustedCosineSimilarity(List<Integer> v1, List<Integer> v2, Double v1mean, Double v2mean) {
        Double result = 0.0;
        int size = v1.size();
        if (v1.size() == v2.size()) {
            Double xy = 0.0;
            Double xx = 0.0;
            Double yy = 0.0;
            for (int i = 0; i < size; ++i) {
                int xi = v1.get(i);
                int yi = v2.get(i);
                xy = xy + ((double)xi - v1mean) * ((double)yi - v2mean);
                xx = xx + ((double)xi - v1mean) * ((double)xi - v1mean);
                yy = yy + ((double)yi - v2mean) * ((double)yi - v2mean);
            }
            if (xx > 0.0 && yy > 0.0) {
                result = xy / (Math.sqrt(xx) * Math.sqrt(yy));
            }
        }
        return result;
    }

    public static Double computeAdjustedCosineSimilarityDoubles(List<Double> v1, List<Double> v2, Double v1mean, Double v2mean) {
        Double result = 0.0;
        int size = v1.size();
        if (v1.size() == v2.size()) {
            Double xy = 0.0;
            Double xx = 0.0;
            Double yy = 0.0;
            for (int i = 0; i < size; ++i) {
                Double xi = v1.get(i);
                Double yi = v2.get(i);
                xy = xy + (xi - v1mean) * (yi - v2mean);
                xx = xx + (xi - v1mean) * (xi - v1mean);
                yy = yy + (yi - v2mean) * (yi - v2mean);
            }
            if (xx > 0.0 && yy > 0.0) {
                result = xy / (Math.sqrt(xx) * Math.sqrt(yy));
            }
        }
        return result;
    }

    public static Double computeAdjustedCosineSimilarity(List<Double> v1, List<Double> v2, boolean adjusted) {
        Double result = 0.0;
        result = !adjusted ? Helper.computeAdjustedCosineSimilarityDoubles(v1, v2) : Helper.computeAdjustedCosineSimilarityDoubles(v1, v2, 0.0, 0.0);
        return result;
    }

    public static Integer getOverlapping(List<Integer> v1, List<Integer> v2) {
        if (v1.size() != v2.size()) {
            return 0;
        }
        int overlapping = 0;
        for (int i = 0; i < v1.size(); ++i) {
            if (v1.get(i) <= 0 || v2.get(i) <= 0) continue;
            ++overlapping;
        }
        return overlapping;
    }

    public static <T> T[] applyPaging(T[] array, Map<String, String> param) {
        if (param != null && param.containsKey(Keys.Page)) {
            String pageSizeString;
            int page = 1;
            int pageSize = Keys.PageSize;
            String pageString = param.get(Keys.Page);
            if (Helper.isIntegerRegex(pageString)) {
                page = Integer.parseInt(pageString);
            }
            if (param.containsKey(Keys.PageSizeKey) && Helper.isIntegerRegex(pageSizeString = param.get(Keys.PageSizeKey))) {
                pageSize = Integer.parseInt(pageSizeString);
            }
            int start = (page - 1) * pageSize;
            int end = page * pageSize;
            if (start >= 0 && start < array.length) {
                if (end <= array.length) {
                    return Arrays.copyOfRange(array, start, end);
                }
                return Arrays.copyOfRange(array, start, array.length);
            }
            return Arrays.copyOfRange(array, 0, 0);
        }
        return array;
    }

    public static <T> List<T> applySubList(List<T> items, Map<String, String> param, int topN) {
        if (param != null && param.containsKey(Keys.Count)) {
            int count = Integer.parseInt(param.get("count"));
            if (items.size() > count) {
                items = items.subList(0, count);
            }
        } else if (items.size() > topN) {
            items = items.subList(0, topN);
        }
        return items;
    }

    public static <T> List<T> applySubList(List<T> items, int topN) {
        if (items.size() > topN) {
            items = items.subList(0, topN);
        }
        return items;
    }

    public static boolean isIntegerRegex(String str) {
        return str != null && str.matches("^[0-9]+$");
    }

    public static class Keys {
        public static final String ExperimentId = "experiment-id".intern();
        public static final String OutputParam = "output".intern();
        public static final String ItemId = "item-id".intern();
        public static final String UserId = "user-id".intern();
        public static final String RelationId = "relation-id".intern();
        public static final String FromId = "from-id".intern();
        public static final String ToId = "to-id".intern();
        public static final String SourceId = "source-id".intern();
        public static final String DataBuilderId = "data-builder-id".intern();
        public static final String RecommenderId = "rec-id".intern();
        public static final String Type = "type".intern();
        public static final String DataSplitterId = "splitter-id".intern();
        public static final String State = "state".intern();
        public static final String Dir = "dir".intern();
        public static final String ID = "id".intern();
        public static final String TopN = "topN".intern();
        public static final String MetricIDs = "metric-ids".intern();
        public static final String Value = "value".intern();
        public static final String RecommenderBuilderId = "rec-builder-id".intern();
        public static final String RecommenderBuilderIdPrefix = "rec-builder-".intern();
        public static final String Page = "page".intern();
        public static final String PageSizeKey = "page-size".intern();
        public static final String Count = "count".intern();
        public static final String Key = "key".intern();
        public static final String TimeStamp = "timeStamp".intern();
        public static final String SplitType = "split-type".intern();
        public static final Integer PageSize = 10;

        public static class Context {
            public static final String LastConsumed = "last-consumed".intern();
            public static final String Params = "params".intern();
            public static final String DataSet = "dataSet".intern();
            public static final String Item = "item".intern();
        }
    }
}

