/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicLong THREAD_POOL_NUM = new AtomicLong(0L);
    private final AtomicLong mThreadNum = new AtomicLong(0L);
    private final String mPrefix;
    private final boolean mIsDaemon;
    private final long mPoolNum;

    public NamedThreadFactory(String pPrefix) {
        this(pPrefix, true);
    }

    public NamedThreadFactory(String pPrefix, boolean pIsDaemon) {
        this.mIsDaemon = pIsDaemon;
        this.mPrefix = pPrefix;
        this.mPoolNum = THREAD_POOL_NUM.incrementAndGet();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.mPrefix + "-" + this.mPoolNum + "-Thread-" + this.mThreadNum.incrementAndGet());
        if (t.isDaemon() != this.mIsDaemon) {
            t.setDaemon(this.mIsDaemon);
        }
        return t;
    }
}

