/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.communication;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public class FillableDataSet
implements DataSet {
    private final ArrayList<Interaction> interactions;
    private final ArrayList<User> users;
    private final ArrayList<Item> items = new ArrayList();
    private final ArrayList<Relation> relations;

    public FillableDataSet() {
        this.users = new ArrayList();
        this.interactions = new ArrayList();
        this.relations = new ArrayList();
    }

    public void addInteraction(Interaction interaction) throws BaseException {
        this.interactions.add(interaction);
    }

    public void addItem(Item item) throws BaseException {
        this.items.add(item);
    }

    public void addUser(User user) throws BaseException {
        this.users.add(user);
    }

    public void addRelation(Relation relation) {
        this.relations.add(relation);
    }

    @Override
    public Interaction[] getInteractions() throws BaseException {
        return this.interactions.toArray(new Interaction[this.interactions.size()]);
    }

    @Override
    public Interaction[] getInteractions(String userId) throws BaseException {
        return (Interaction[])this.interactions.stream().filter(i -> i.getUserId().equals(userId)).toArray(Interaction[]::new);
    }

    @Override
    public Item[] getItems() throws BaseException {
        return this.items.toArray(new Item[this.items.size()]);
    }

    @Override
    public User[] getUsers() throws BaseException {
        return this.users.toArray(new User[this.users.size()]);
    }

    @Override
    public Relation[] getRelations() throws BaseException {
        return this.relations.toArray(new Relation[this.relations.size()]);
    }

    @Override
    public Relation getRelation(String relationId) throws BaseException {
        Optional<Relation> item = this.relations.stream().filter(i -> i.getId().equals(relationId)).findFirst();
        return item.isPresent() ? item.get() : null;
    }

    @Override
    public Relation[] getRelationsFor(String fromId) throws BaseException {
        return (Relation[])this.relations.stream().filter(i -> i.getFromId().equals(fromId)).toArray(Relation[]::new);
    }

    @Override
    public Relation[] getRelations(String fromId, String toId) throws BaseException {
        if (fromId != null && toId == null) {
            return (Relation[])this.relations.stream().filter(i -> i.getFromId().equals(fromId)).toArray(Relation[]::new);
        }
        if (fromId == null && toId != null) {
            return (Relation[])this.relations.stream().filter(i -> i.getToId().equals(toId)).toArray(Relation[]::new);
        }
        return (Relation[])this.relations.stream().filter(i -> i.getFromId().equals(fromId) && i.getToId().equals(toId)).toArray(Relation[]::new);
    }

    @Override
    public Item getItem(String itemId) throws BaseException {
        Optional<Item> item = this.items.stream().filter(i -> i.getId().equals(itemId)).findFirst();
        return item.isPresent() ? item.get() : null;
    }

    @Override
    public User getUser(String userId) throws BaseException {
        Optional<User> user = this.users.stream().filter(u -> u.getId().equals(userId)).findFirst();
        return user.isPresent() ? user.get() : null;
    }

    @Override
    public int getItemsCount() {
        return this.items.size();
    }

    @Override
    public int getUsersCount() {
        return this.users.size();
    }

    @Override
    public int getInteractionsCount() {
        return this.interactions.size();
    }

    @Override
    public int getRelationCount() {
        return this.relations.size();
    }

    public static DataSet createDataSet(DataSet dataSet, Interaction[] omitInteractions) throws BaseException {
        FillableDataSet temp = new FillableDataSet();
        HashMap<String, Boolean> interactionMap = new HashMap<String, Boolean>();
        for (Interaction interaction : omitInteractions) {
            interactionMap.put(interaction.getId(), true);
        }
        for (Interaction interaction : dataSet.getInteractions()) {
            if (interactionMap.containsKey(interaction.getId())) continue;
            temp.addInteraction(interaction);
        }
        for (Serializable serializable : dataSet.getUsers()) {
            temp.addUser((User)serializable);
        }
        for (Serializable serializable : dataSet.getItems()) {
            temp.addItem((Item)serializable);
        }
        for (Serializable serializable : dataSet.getRelations()) {
            temp.addRelation((Relation)serializable);
        }
        return temp;
    }
}

