/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.communication;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class InnerIds {
    private static final LinkedHashMap<String, Integer> ids;
    private static final Map<Integer, String> revert;
    private static final Map<Integer, Boolean> intValues;
    private static final Map<Integer, Boolean> taken;
    private static int next;
    private static final char[] digits;

    public static int getId(String rawId) {
        if (rawId.length() < 10) {
            try {
                int r = Integer.parseInt(rawId, 10);
                return r;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!ids.containsKey(rawId)) {
            return -1;
        }
        return ids.get(rawId);
    }

    public static String getId(int innerId) {
        if (revert.containsKey(innerId)) {
            return revert.get(innerId);
        }
        if (intValues.containsKey(innerId)) {
            return "" + innerId;
        }
        return null;
    }

    public static int getNextId(String rawId) {
        if (ids.containsKey(rawId)) {
            return ids.get(rawId);
        }
        if (rawId.length() < 10) {
            try {
                int r = Integer.parseInt(rawId, 10);
                if (!taken.containsKey(r)) {
                    intValues.put(r, true);
                    taken.put(r, true);
                    return r;
                }
            }
            catch (NumberFormatException r) {
                // empty catch block
            }
        }
        while (taken.containsKey(next)) {
            ++next;
        }
        int innerId = next;
        ids.put(rawId, innerId);
        revert.put(innerId, rawId);
        taken.put(innerId, true);
        return innerId;
    }

    public static String decToNewBase(int dec, int base) {
        StringBuilder sb = new StringBuilder();
        for (int num = dec; num > 0; num /= base) {
            int rem = num % base;
            sb.reverse().append(digits[rem]).reverse();
        }
        return sb.toString();
    }

    public static String decTo36base(int dec) {
        return InnerIds.decToNewBase(dec, digits.length);
    }

    static {
        next = 0;
        ids = new LinkedHashMap();
        revert = new HashMap<Integer, String>();
        intValues = new HashMap<Integer, Boolean>();
        taken = new HashMap<Integer, Boolean>();
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

