/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.common.interfaces.model.experiment;

import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.log.Loggable;
import java.util.HashMap;
import java.util.Map;

public abstract class Experiment
extends Loggable {
    protected HashMap<String, Map<String, Double>> result;
    protected String dataSourceId;
    protected String[] recommenderIds;
    protected ExperimentState state;
    protected String id;
    protected String info;
    protected double percentage;
    protected Recommender[] recommenders;
    protected Map<String, String> config;

    public void setInfo(String info) {
        this.info = info;
    }

    public String getInfo() {
        return this.info;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double p) {
        this.percentage = p;
    }

    public synchronized void addPercentage(double percentage) {
        this.percentage += percentage;
        if (this.percentage > 100.0) {
            this.percentage = 100.0;
        }
    }

    public synchronized void resetPercentage() {
        this.percentage = 0.0;
    }

    public HashMap<String, Map<String, Double>> getResults() {
        return this.result;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String[] getRecommenderIds() {
        return this.recommenderIds;
    }

    public ExperimentState getState() {
        return this.state;
    }

    public void setState(ExperimentState state) {
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public abstract void run();

    public static enum ExperimentState {
        WAITING,
        RUNNING,
        FINISHED;

    }
}

