/*
 * Decompiled with CFR 0.152.
 */
package flexjson;

import flexjson.ChainedIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChainedSet
implements Set {
    Set parent;
    Set child;

    public ChainedSet(Set parent) {
        this.parent = parent;
        this.child = new HashSet();
    }

    @Override
    public int size() {
        return this.child.size() + this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.child.isEmpty() && this.parent.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.child.contains(o) || this.parent.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new ChainedIterator(this.child, this.parent);
    }

    @Override
    public Object[] toArray() {
        Object[] carr = this.child.toArray();
        Object[] parr = this.parent.toArray();
        Object[] combined = new Object[carr.length + parr.length];
        System.arraycopy(carr, 0, combined, 0, carr.length);
        System.arraycopy(parr, 0, combined, carr.length, parr.length);
        return combined;
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new IllegalStateException("Not implemeneted");
    }

    @Override
    public boolean add(Object o) {
        return this.child.add(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.child.remove(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.child.containsAll(c) || this.parent.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.child.addAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        return this.child.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        return this.child.removeAll(c);
    }

    @Override
    public void clear() {
        this.child.clear();
    }

    public Set getParent() {
        return this.parent;
    }
}

