/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Hashtable;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.impl.OSGiRepositoryImpl;
import org.apache.felix.bundlerepository.impl.ObrCommandImpl;
import org.apache.felix.bundlerepository.impl.ObrURLStreamHandlerService;
import org.apache.felix.bundlerepository.impl.RepositoryAdminImpl;
import org.apache.felix.bundlerepository.impl.wrapper.Wrapper;
import org.apache.felix.shell.Command;
import org.apache.felix.utils.log.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.repository.Repository;
import org.osgi.service.url.URLStreamHandlerService;

public class Activator
implements BundleActivator {
    private static BundleContext context = null;
    private static Logger logger = new Logger(null);
    private transient RepositoryAdminImpl m_repoAdmin = null;

    public static BundleContext getContext() {
        return context;
    }

    static void setContext(BundleContext context) {
        Activator.context = context;
    }

    public static void log(int level, String message) {
        if (logger != null) {
            logger.log(level, message);
        }
    }

    public static void log(int level, String message, Throwable exception) {
        if (logger != null) {
            logger.log(level, message, exception);
        }
    }

    public void start(BundleContext context) {
        Activator.context = context;
        logger = new Logger(context);
        this.m_repoAdmin = new RepositoryAdminImpl(context, logger);
        context.registerService(RepositoryAdmin.class.getName(), (Object)this.m_repoAdmin, null);
        context.registerService(Repository.class.getName(), (Object)new OSGiRepositoryImpl(this.m_repoAdmin), null);
        try {
            context.registerService(org.osgi.service.obr.RepositoryAdmin.class.getName(), (Object)Wrapper.wrap(this.m_repoAdmin), null);
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            context.registerService(Command.class.getName(), (Object)new ObrCommandImpl(Activator.context, this.m_repoAdmin), null);
        }
        catch (Throwable th) {
            // empty catch block
        }
        try {
            Hashtable<String, String> dict = new Hashtable<String, String>();
            dict.put("url.handler.protocol", "obr");
            context.registerService(URLStreamHandlerService.class.getName(), (Object)new ObrURLStreamHandlerService(Activator.context, this.m_repoAdmin), dict);
        }
        catch (Exception e) {
            throw new RuntimeException("could not register obr url handler");
        }
    }

    public void stop(BundleContext context) {
        this.m_repoAdmin.dispose();
    }
}

