/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.DataModelHelper;
import org.apache.felix.bundlerepository.Property;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.bundlerepository.impl.CapabilityImpl;
import org.apache.felix.bundlerepository.impl.FileUtil;
import org.apache.felix.bundlerepository.impl.Referral;
import org.apache.felix.bundlerepository.impl.RepositoryImpl;
import org.apache.felix.bundlerepository.impl.RepositoryParser;
import org.apache.felix.bundlerepository.impl.RequirementImpl;
import org.apache.felix.bundlerepository.impl.ResourceImpl;
import org.apache.felix.bundlerepository.impl.XmlWriter;
import org.apache.felix.utils.filter.FilterImpl;
import org.apache.felix.utils.manifest.Attribute;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Directive;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class DataModelHelperImpl
implements DataModelHelper {
    public static final String BUNDLE_LICENSE = "Bundle-License";
    public static final String BUNDLE_SOURCE = "Bundle-Source";

    public Requirement requirement(String name, String filter) {
        RequirementImpl req = new RequirementImpl();
        req.setName(name);
        if (filter != null) {
            req.setFilter(filter);
        }
        return req;
    }

    public Filter filter(String filter) {
        try {
            return FilterImpl.newInstance(filter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public Repository repository(URL url) throws Exception {
        InputStream is = null;
        Object br = null;
        try {
            if (url.getPath().endsWith(".zip")) {
                ZipInputStream zin = new ZipInputStream(FileUtil.openURL(url));
                ZipEntry entry = zin.getNextEntry();
                while (entry != null) {
                    if (entry.getName().equals("repository.xml")) {
                        is = zin;
                        break;
                    }
                    entry = zin.getNextEntry();
                }
            } else {
                is = FileUtil.openURL(url);
            }
            if (is != null) {
                RepositoryImpl repository = this.repository(is);
                repository.setURI(url.toExternalForm());
                RepositoryImpl repositoryImpl = repository;
                return repositoryImpl;
            }
            throw new Exception("Unable to get input stream for repository.");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public RepositoryImpl repository(InputStream is) throws Exception {
        RepositoryParser parser = RepositoryParser.getParser();
        RepositoryImpl repository = parser.parseRepository(is);
        return repository;
    }

    public Repository repository(Resource[] resources) {
        return new RepositoryImpl(resources);
    }

    public Capability capability(String name, Map properties) {
        CapabilityImpl cap = new CapabilityImpl(name);
        for (Map.Entry e : properties.entrySet()) {
            cap.addProperty((String)e.getKey(), (String)e.getValue());
        }
        return cap;
    }

    public String writeRepository(Repository repository) {
        try {
            StringWriter sw = new StringWriter();
            this.writeRepository(repository, sw);
            return sw.toString();
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public void writeRepository(Repository repository, Writer writer) throws IOException {
        XmlWriter w = new XmlWriter(writer);
        DataModelHelperImpl.toXml(w, repository);
    }

    public String writeResource(Resource resource) {
        try {
            StringWriter sw = new StringWriter();
            this.writeResource(resource, sw);
            return sw.toString();
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public void writeResource(Resource resource, Writer writer) throws IOException {
        XmlWriter w = new XmlWriter(writer);
        DataModelHelperImpl.toXml(w, resource);
    }

    public String writeCapability(Capability capability) {
        try {
            StringWriter sw = new StringWriter();
            this.writeCapability(capability, sw);
            return sw.toString();
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public void writeCapability(Capability capability, Writer writer) throws IOException {
        XmlWriter w = new XmlWriter(writer);
        DataModelHelperImpl.toXml(w, capability);
    }

    public String writeRequirement(Requirement requirement) {
        try {
            StringWriter sw = new StringWriter();
            this.writeRequirement(requirement, sw);
            return sw.toString();
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public void writeRequirement(Requirement requirement, Writer writer) throws IOException {
        XmlWriter w = new XmlWriter(writer);
        DataModelHelperImpl.toXml(w, requirement);
    }

    public String writeProperty(Property property) {
        try {
            StringWriter sw = new StringWriter();
            this.writeProperty(property, sw);
            return sw.toString();
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public void writeProperty(Property property, Writer writer) throws IOException {
        XmlWriter w = new XmlWriter(writer);
        DataModelHelperImpl.toXml(w, property);
    }

    private static void toXml(XmlWriter w, Repository repository) throws IOException {
        int i;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddhhmmss.SSS");
        w.element("repository").attribute("name", repository.getName()).attribute("lastmodified", format.format(new Date(repository.getLastModified())));
        if (repository instanceof RepositoryImpl) {
            Referral[] referrals = ((RepositoryImpl)repository).getReferrals();
            for (i = 0; referrals != null && i < referrals.length; ++i) {
                w.element("referral").attribute("depth", new Integer(referrals[i].getDepth())).attribute("url", referrals[i].getUrl()).end();
            }
        }
        Resource[] resources = repository.getResources();
        for (i = 0; resources != null && i < resources.length; ++i) {
            DataModelHelperImpl.toXml(w, resources[i]);
        }
        w.end();
    }

    private static void toXml(XmlWriter w, Resource resource) throws IOException {
        w.element("resource").attribute("id", resource.getId()).attribute("symbolicname", resource.getSymbolicName()).attribute("presentationname", resource.getPresentationName()).attribute("uri", DataModelHelperImpl.getRelativeUri(resource, "uri")).attribute("version", resource.getVersion().toString());
        w.textElement("description", resource.getProperties().get("description")).textElement("size", resource.getProperties().get("size")).textElement("documentation", DataModelHelperImpl.getRelativeUri(resource, "documentation")).textElement("source", DataModelHelperImpl.getRelativeUri(resource, "source")).textElement("javadoc", DataModelHelperImpl.getRelativeUri(resource, "javadoc")).textElement("license", DataModelHelperImpl.getRelativeUri(resource, "license"));
        String[] categories = resource.getCategories();
        for (int i = 0; categories != null && i < categories.length; ++i) {
            w.element("category").attribute("id", categories[i]).end();
        }
        Capability[] capabilities = resource.getCapabilities();
        for (int i = 0; capabilities != null && i < capabilities.length; ++i) {
            DataModelHelperImpl.toXml(w, capabilities[i]);
        }
        Requirement[] requirements = resource.getRequirements();
        for (int i = 0; requirements != null && i < requirements.length; ++i) {
            DataModelHelperImpl.toXml(w, requirements[i]);
        }
        w.end();
    }

    private static String getRelativeUri(Resource resource, String name) {
        String uri = (String)resource.getProperties().get(name);
        if (resource instanceof ResourceImpl) {
            try {
                uri = URI.create(((ResourceImpl)resource).getRepository().getURI()).relativize(URI.create(uri)).toASCIIString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return uri;
    }

    private static void toXml(XmlWriter w, Capability capability) throws IOException {
        w.element("capability").attribute("name", capability.getName());
        Property[] props = capability.getProperties();
        for (int j = 0; props != null && j < props.length; ++j) {
            DataModelHelperImpl.toXml(w, props[j]);
        }
        w.end();
    }

    private static void toXml(XmlWriter w, Property property) throws IOException {
        w.element("p").attribute("n", property.getName()).attribute("t", property.getType()).attribute("v", property.getValue()).end();
    }

    private static void toXml(XmlWriter w, Requirement requirement) throws IOException {
        w.element("require").attribute("name", requirement.getName()).attribute("filter", requirement.getFilter()).attribute("extend", Boolean.toString(requirement.isExtend())).attribute("multiple", Boolean.toString(requirement.isMultiple())).attribute("optional", Boolean.toString(requirement.isOptional())).text(requirement.getComment().trim()).end();
    }

    public Resource createResource(Bundle bundle) {
        final Dictionary dict = bundle.getHeaders();
        return this.createResource(new Headers(){

            public String getHeader(String name) {
                return (String)dict.get(name);
            }
        });
    }

    public Resource createResource(final URL bundleUrl) throws IOException {
        ResourceImpl resource = this.createResource(new Headers(){
            private final Manifest manifest;
            private Properties localization;
            {
                byte[] man = this.loadEntry("META-INF/MANIFEST.MF");
                if (man == null) {
                    throw new IllegalArgumentException("The specified url is not a valid jar (can't read manifest): " + bundleUrl);
                }
                this.manifest = new Manifest(new ByteArrayInputStream(man));
            }

            public String getHeader(String name) {
                String value = this.manifest.getMainAttributes().getValue(name);
                if (value != null && value.startsWith("%")) {
                    if (this.localization == null) {
                        try {
                            byte[] loc;
                            this.localization = new Properties();
                            String path = this.manifest.getMainAttributes().getValue("Bundle-Localization");
                            if (path == null) {
                                path = "OSGI-INF/l10n/bundle";
                            }
                            if ((loc = this.loadEntry(path = path + ".properties")) != null) {
                                this.localization.load(new ByteArrayInputStream(loc));
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    value = value.substring(1);
                    value = this.localization.getProperty(value, value);
                }
                return value;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] loadEntry(String name) throws IOException {
                InputStream is = FileUtil.openURL(bundleUrl);
                try {
                    ZipInputStream jis = new ZipInputStream(is);
                    ZipEntry e = jis.getNextEntry();
                    while (e != null) {
                        if (name.equalsIgnoreCase(e.getName())) {
                            int n;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            byte[] buf = new byte[1024];
                            while ((n = jis.read(buf, 0, buf.length)) > 0) {
                                baos.write(buf, 0, n);
                            }
                            byte[] byArray = baos.toByteArray();
                            return byArray;
                        }
                        e = jis.getNextEntry();
                    }
                }
                finally {
                    is.close();
                }
                return null;
            }
        });
        if (resource != null) {
            if ("file".equals(bundleUrl.getProtocol())) {
                try {
                    File f = new File(bundleUrl.toURI());
                    resource.put("size", Long.toString(f.length()), null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            resource.put("uri", bundleUrl.toExternalForm(), null);
        }
        return resource;
    }

    public Resource createResource(final Attributes attributes) {
        return this.createResource(new Headers(){

            public String getHeader(String name) {
                return attributes.getValue(name);
            }
        });
    }

    public ResourceImpl createResource(Headers headers) {
        String bsn = headers.getHeader("Bundle-SymbolicName");
        if (bsn == null) {
            return null;
        }
        ResourceImpl resource = new ResourceImpl();
        DataModelHelperImpl.populate(headers, resource);
        return resource;
    }

    static void populate(Headers headers, ResourceImpl resource) {
        String bsn = DataModelHelperImpl.getSymbolicName(headers);
        String v = DataModelHelperImpl.getVersion(headers);
        resource.put("id", bsn + "/" + v);
        resource.put("symbolicname", bsn);
        resource.put("version", v);
        if (headers.getHeader("Bundle-Name") != null) {
            resource.put("presentationname", headers.getHeader("Bundle-Name"));
        }
        if (headers.getHeader("Bundle-Description") != null) {
            resource.put("description", headers.getHeader("Bundle-Description"));
        }
        if (headers.getHeader(BUNDLE_LICENSE) != null) {
            resource.put("license", headers.getHeader(BUNDLE_LICENSE));
        }
        if (headers.getHeader("Bundle-Copyright") != null) {
            resource.put("copyright", headers.getHeader("Bundle-Copyright"));
        }
        if (headers.getHeader("Bundle-DocURL") != null) {
            resource.put("documentation", headers.getHeader("Bundle-DocURL"));
        }
        if (headers.getHeader(BUNDLE_SOURCE) != null) {
            resource.put("source", headers.getHeader(BUNDLE_SOURCE));
        }
        DataModelHelperImpl.doCategories(resource, headers);
        DataModelHelperImpl.doBundle(resource, headers);
        DataModelHelperImpl.doImportExportServices(resource, headers);
        DataModelHelperImpl.doFragment(resource, headers);
        DataModelHelperImpl.doRequires(resource, headers);
        DataModelHelperImpl.doExports(resource, headers);
        DataModelHelperImpl.doImports(resource, headers);
        DataModelHelperImpl.doExecutionEnvironment(resource, headers);
    }

    private static void doCategories(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Bundle-Category"));
        for (int i = 0; clauses != null && i < clauses.length; ++i) {
            resource.addCategory(clauses[i].getName());
        }
    }

    private static void doImportExportServices(ResourceImpl resource, Headers headers) {
        Clause[] imports = Parser.parseHeader(headers.getHeader("Import-Service"));
        for (int i = 0; imports != null && i < imports.length; ++i) {
            RequirementImpl ri = new RequirementImpl("service");
            ri.setFilter(DataModelHelperImpl.createServiceFilter(imports[i]));
            ri.addText("Import Service " + imports[i].getName());
            String avail = imports[i].getDirective("availability");
            String mult = imports[i].getDirective("multiple");
            ri.setOptional("optional".equalsIgnoreCase(avail));
            ri.setMultiple(!"false".equalsIgnoreCase(mult));
            resource.addRequire(ri);
        }
        Clause[] exports = Parser.parseHeader(headers.getHeader("Export-Service"));
        for (int i = 0; exports != null && i < exports.length; ++i) {
            CapabilityImpl cap = DataModelHelperImpl.createServiceCapability(exports[i]);
            resource.addCapability(cap);
        }
    }

    private static String createServiceFilter(Clause clause) {
        String f = clause.getAttribute("filter");
        StringBuffer filter = new StringBuffer();
        if (f != null) {
            filter.append("(&");
        }
        filter.append("(");
        filter.append("service");
        filter.append("=");
        filter.append(clause.getName());
        filter.append(")");
        if (f != null) {
            if (!f.startsWith("(")) {
                filter.append("(").append(f).append(")");
            } else {
                filter.append(f);
            }
            filter.append(")");
        }
        return filter.toString();
    }

    private static CapabilityImpl createServiceCapability(Clause clause) {
        CapabilityImpl capability = new CapabilityImpl("service");
        capability.addProperty("service", clause.getName());
        Attribute[] attributes = clause.getAttributes();
        for (int i = 0; attributes != null && i < attributes.length; ++i) {
            capability.addProperty(attributes[i].getName(), attributes[i].getValue());
        }
        return capability;
    }

    private static void doFragment(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Fragment-Host"));
        if (clauses != null && clauses.length == 1) {
            RequirementImpl r = new RequirementImpl("bundle");
            StringBuffer sb = new StringBuffer();
            sb.append("(&(symbolicname=");
            sb.append(clauses[0].getName());
            sb.append(")");
            DataModelHelperImpl.appendVersion(sb, VersionRange.parseVersionRange(clauses[0].getAttribute("bundle-version")));
            sb.append(")");
            r.setFilter(sb.toString());
            r.addText("Required Host " + clauses[0].getName());
            r.setExtend(true);
            r.setOptional(false);
            r.setMultiple(false);
            resource.addRequire(r);
            CapabilityImpl capability = new CapabilityImpl("fragment");
            capability.addProperty("host", clauses[0].getName());
            capability.addProperty("version", "version", DataModelHelperImpl.getVersion(clauses[0]));
            resource.addCapability(capability);
        }
    }

    private static void doRequires(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Require-Bundle"));
        for (int i = 0; clauses != null && i < clauses.length; ++i) {
            RequirementImpl r = new RequirementImpl("bundle");
            VersionRange v = VersionRange.parseVersionRange(clauses[i].getAttribute("bundle-version"));
            StringBuffer sb = new StringBuffer();
            sb.append("(&(symbolicname=");
            sb.append(clauses[i].getName());
            sb.append(")");
            DataModelHelperImpl.appendVersion(sb, v);
            sb.append(")");
            r.setFilter(sb.toString());
            r.addText("Require Bundle " + clauses[i].getName() + "; " + v);
            r.setOptional("optional".equalsIgnoreCase(clauses[i].getDirective("resolution")));
            resource.addRequire(r);
        }
    }

    private static void doBundle(ResourceImpl resource, Headers headers) {
        CapabilityImpl capability = new CapabilityImpl("bundle");
        capability.addProperty("symbolicname", DataModelHelperImpl.getSymbolicName(headers));
        if (headers.getHeader("Bundle-Name") != null) {
            capability.addProperty("presentationname", headers.getHeader("Bundle-Name"));
        }
        capability.addProperty("version", "version", DataModelHelperImpl.getVersion(headers));
        capability.addProperty("manifestversion", DataModelHelperImpl.getManifestVersion(headers));
        resource.addCapability(capability);
    }

    private static void doExports(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Export-Package"));
        for (int i = 0; clauses != null && i < clauses.length; ++i) {
            CapabilityImpl capability = DataModelHelperImpl.createCapability("package", clauses[i]);
            resource.addCapability(capability);
        }
    }

    private static CapabilityImpl createCapability(String name, Clause clause) {
        CapabilityImpl capability = new CapabilityImpl(name);
        capability.addProperty(name, clause.getName());
        capability.addProperty("version", "version", DataModelHelperImpl.getVersion(clause));
        Attribute[] attributes = clause.getAttributes();
        for (int i = 0; attributes != null && i < attributes.length; ++i) {
            String key = attributes[i].getName();
            if (key.equalsIgnoreCase("specification-version") || key.equalsIgnoreCase("version")) continue;
            String value = attributes[i].getValue();
            capability.addProperty(key, value);
        }
        Directive[] directives = clause.getDirectives();
        for (int i = 0; directives != null && i < directives.length; ++i) {
            String key = directives[i].getName();
            String value = directives[i].getValue();
            capability.addProperty(key + ":", value);
        }
        return capability;
    }

    private static void doImports(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Import-Package"));
        for (int i = 0; clauses != null && i < clauses.length; ++i) {
            RequirementImpl requirement = new RequirementImpl("package");
            DataModelHelperImpl.createImportFilter(requirement, "package", clauses[i]);
            requirement.addText("Import package " + clauses[i]);
            requirement.setOptional("optional".equalsIgnoreCase(clauses[i].getDirective("resolution")));
            resource.addRequire(requirement);
        }
    }

    private static void createImportFilter(RequirementImpl requirement, String name, Clause clause) {
        StringBuffer filter = new StringBuffer();
        filter.append("(&(");
        filter.append(name);
        filter.append("=");
        filter.append(clause.getName());
        filter.append(")");
        DataModelHelperImpl.appendVersion(filter, DataModelHelperImpl.getVersionRange(clause));
        Attribute[] attributes = clause.getAttributes();
        Set attrs = DataModelHelperImpl.doImportPackageAttributes(requirement, filter, attributes);
        if (attrs.size() > 0) {
            String del = "";
            filter.append("(mandatory:<*");
            Iterator i = attrs.iterator();
            while (i.hasNext()) {
                filter.append(del);
                filter.append(i.next());
                del = ", ";
            }
            filter.append(")");
        }
        filter.append(")");
        requirement.setFilter(filter.toString());
    }

    private static Set doImportPackageAttributes(RequirementImpl requirement, StringBuffer filter, Attribute[] attributes) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; attributes != null && i < attributes.length; ++i) {
            String name = attributes[i].getName();
            String value = attributes[i].getValue();
            if (name.equalsIgnoreCase("specification-version") || name.equalsIgnoreCase("version")) continue;
            if (name.equalsIgnoreCase("resolution:")) {
                requirement.setOptional("optional".equalsIgnoreCase(value));
            }
            if (name.endsWith(":")) continue;
            filter.append("(");
            filter.append(name);
            filter.append("=");
            filter.append(value);
            filter.append(")");
            set.add(name);
        }
        return set;
    }

    private static void doExecutionEnvironment(ResourceImpl resource, Headers headers) {
        Clause[] clauses = Parser.parseHeader(headers.getHeader("Bundle-RequiredExecutionEnvironment"));
        if (clauses != null && clauses.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("(|");
            for (int i = 0; i < clauses.length; ++i) {
                sb.append("(");
                sb.append("ee");
                sb.append("=");
                sb.append(clauses[i].getName());
                sb.append(")");
            }
            sb.append(")");
            RequirementImpl req = new RequirementImpl("ee");
            req.setFilter(sb.toString());
            req.addText("Execution Environment " + sb.toString());
            resource.addRequire(req);
        }
    }

    private static String getVersion(Clause clause) {
        String v = clause.getAttribute("version");
        if (v == null) {
            v = clause.getAttribute("specification-version");
        }
        if (v == null) {
            v = clause.getAttribute("bundle-version");
        }
        return VersionCleaner.clean(v);
    }

    private static VersionRange getVersionRange(Clause clause) {
        String v = clause.getAttribute("version");
        if (v == null) {
            v = clause.getAttribute("specification-version");
        }
        if (v == null) {
            v = clause.getAttribute("bundle-version");
        }
        return VersionRange.parseVersionRange(v);
    }

    private static String getSymbolicName(Headers headers) {
        String bsn = headers.getHeader("Bundle-SymbolicName");
        if (bsn == null && (bsn = headers.getHeader("Bundle-Name")) == null) {
            bsn = "Untitled-" + headers.hashCode();
        }
        Clause[] clauses = Parser.parseHeader(bsn);
        return clauses[0].getName();
    }

    private static String getVersion(Headers headers) {
        String v = headers.getHeader("Bundle-Version");
        return VersionCleaner.clean(v);
    }

    private static String getManifestVersion(Headers headers) {
        String v = headers.getHeader("Bundle-ManifestVersion");
        if (v == null) {
            v = "1";
        }
        return v;
    }

    private static void appendVersion(StringBuffer filter, VersionRange version) {
        if (version != null) {
            if (!version.isOpenFloor()) {
                if (!Version.emptyVersion.equals((Object)version.getFloor())) {
                    filter.append("(");
                    filter.append("version");
                    filter.append(">=");
                    filter.append(version.getFloor());
                    filter.append(")");
                }
            } else {
                filter.append("(!(");
                filter.append("version");
                filter.append("<=");
                filter.append(version.getFloor());
                filter.append("))");
            }
            if (!VersionRange.INFINITE_VERSION.equals((Object)version.getCeiling())) {
                if (!version.isOpenCeiling()) {
                    filter.append("(");
                    filter.append("version");
                    filter.append("<=");
                    filter.append(version.getCeiling());
                    filter.append(")");
                } else {
                    filter.append("(!(");
                    filter.append("version");
                    filter.append(">=");
                    filter.append(version.getCeiling());
                    filter.append("))");
                }
            }
        }
    }

    public Repository readRepository(String xml) throws Exception {
        try {
            return this.readRepository(new StringReader(xml));
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public Repository readRepository(Reader reader) throws Exception {
        return RepositoryParser.getParser().parseRepository(reader);
    }

    public Resource readResource(String xml) throws Exception {
        try {
            return this.readResource(new StringReader(xml));
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public Resource readResource(Reader reader) throws Exception {
        return RepositoryParser.getParser().parseResource(reader);
    }

    public Capability readCapability(String xml) throws Exception {
        try {
            return this.readCapability(new StringReader(xml));
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public Capability readCapability(Reader reader) throws Exception {
        return RepositoryParser.getParser().parseCapability(reader);
    }

    public Requirement readRequirement(String xml) throws Exception {
        try {
            return this.readRequirement(new StringReader(xml));
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public Requirement readRequirement(Reader reader) throws Exception {
        return RepositoryParser.getParser().parseRequirement(reader);
    }

    public Property readProperty(String xml) throws Exception {
        try {
            return this.readProperty(new StringReader(xml));
        }
        catch (IOException e) {
            IllegalStateException ex = new IllegalStateException(e);
            ex.initCause(e);
            throw ex;
        }
    }

    public Property readProperty(Reader reader) throws Exception {
        return RepositoryParser.getParser().parseProperty(reader);
    }

    static interface Headers {
        public String getHeader(String var1);
    }
}

