/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.views.data.sources;

import com.recalot.common.Helper;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.interfaces.controller.DataAccessController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.views.common.GenericControllerHandler;
import com.recalot.views.common.HTTPMethods;
import com.recalot.views.common.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Servlet
extends HttpServlet {
    private GenericControllerHandler handler;
    private Pattern pattern;

    public Servlet(GenericControllerHandler handler) {
        this.handler = handler;
        this.pattern = Pattern.compile("(\\/)([\\w\\-\\+]*)+");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.POST);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.DELETE);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.processRequest(req, res, HTTPMethods.PUT);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        WebService.processOptionsRequest((HttpServletRequest)req, (HttpServletResponse)res, (String)"GET, POST, PUT, DELETE, OPTIONS");
    }

    protected void processRequest(HttpServletRequest req, HttpServletResponse res, HTTPMethods method) throws ServletException, IOException {
        String tempKey;
        res.setHeader("Access-Control-Allow-Origin", "*");
        String pathInfo = req.getPathInfo();
        HashMap<String, String> params = new HashMap<String, String>();
        Map names = req.getParameterMap();
        if (names != null) {
            for (Object key : names.keySet()) {
                params.put(URLDecoder.decode((String)key, "UTF-8"), URLDecoder.decode(req.getParameter((String)key), "UTF-8"));
            }
        }
        String templateKey = "json";
        if (params.containsKey(Helper.Keys.OutputParam) && (tempKey = (String)params.get(Helper.Keys.OutputParam)) != null && !tempKey.equals("")) {
            templateKey = tempKey;
        }
        TemplateResult result = null;
        try {
            if (pathInfo != null && !pathInfo.equals("") && pathInfo.length() > 1) {
                Matcher matcher = this.pattern.matcher(pathInfo);
                while (matcher.find()) {
                    String sourceId;
                    if (matcher.groupCount() <= 1 || (sourceId = matcher.group(0).substring(1)) == null || sourceId.equals("")) continue;
                    boolean isConnection = false;
                    if (sourceId.startsWith("data-builder-")) {
                        params.put(Helper.Keys.SourceId, sourceId.replace("data-builder-", ""));
                        isConnection = true;
                    } else {
                        params.put(Helper.Keys.SourceId, sourceId);
                    }
                    switch (method) {
                        case PUT: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.UpdateSource, templateKey, params);
                            break;
                        }
                        case GET: {
                            if (isConnection) {
                                result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetDataSourceBuilder, templateKey, params);
                                break;
                            }
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetSource, templateKey, params);
                            break;
                        }
                        case DELETE: {
                            result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.DeleteSource, templateKey, params);
                        }
                    }
                }
            } else if (pathInfo == null || pathInfo.equals("") || pathInfo.length() == 1) {
                switch (method) {
                    case GET: {
                        result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.GetSources, templateKey, params);
                        break;
                    }
                    case PUT: {
                        result = this.handler.process((RequestAction)DataAccessController.DataAccessRequestAction.CreateSource, templateKey, params);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (result != null) {
            res.setContentType(result.getContentType());
            res.setCharacterEncoding(result.getCharset().name());
            res.setStatus(result.getStatus());
            PrintWriter out = res.getWriter();
            Helper.copy((PrintWriter)out, (InputStream)result.getResult());
        }
    }
}

