/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.librec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Table;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import librec.data.SparseMatrix;
import librec.data.SparseTensor;

public class DataDAO {
    private SparseMatrix rateMatrix;
    private SparseMatrix timeMatrix;
    private SparseMatrix relationshipMatrix;
    private SparseTensor rateTensor;
    private List<Double> ratingScale;
    private Multiset<Double> scaleDist;
    private int numRatings;
    private BiMap<Integer, Integer> userIds = HashBiMap.create();
    private BiMap<Integer, Integer> itemIds = HashBiMap.create();
    private BiMap<Integer, Integer> idUsers;
    private BiMap<Integer, Integer> idItems;
    private long minTimestamp;
    private long maxTimestamp;
    private DataSet dataSet;

    public DataDAO() {
        this.scaleDist = HashMultiset.create();
    }

    public SparseMatrix[] readData(String ... relationshipType) throws Exception {
        double epsilon;
        int row;
        HashBasedTable dataTable = HashBasedTable.create();
        HashBasedTable timeTable = null;
        HashBasedTable relationshipTable = null;
        HashMultimap rColMap = null;
        HashMultimap colMap = HashMultimap.create();
        this.minTimestamp = Long.MAX_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        for (User user : this.dataSet.getUsers()) {
            row = this.userIds.containsKey((Object)InnerIds.getId((String)user.getId())) ? ((Integer)this.userIds.get((Object)InnerIds.getId((String)user.getId()))).intValue() : this.userIds.size();
            this.userIds.put((Object)InnerIds.getId((String)user.getId()), (Object)row);
        }
        for (User user : this.dataSet.getItems()) {
            int col = this.itemIds.containsKey((Object)InnerIds.getId((String)user.getId())) ? ((Integer)this.itemIds.get((Object)InnerIds.getId((String)user.getId()))).intValue() : this.itemIds.size();
            this.itemIds.put((Object)InnerIds.getId((String)user.getId()), (Object)col);
        }
        if (this.dataSet.getRelationCount() > 0) {
            relationshipTable = HashBasedTable.create();
            rColMap = HashMultimap.create();
            for (User user : this.dataSet.getRelations()) {
                if (relationshipType.length != 0 && !user.getType().toLowerCase().equals(relationshipType[0])) continue;
                if (!this.userIds.containsKey((Object)InnerIds.getId((String)user.getFromId()))) {
                    this.userIds.put((Object)InnerIds.getId((String)user.getFromId()), (Object)this.userIds.size());
                }
                if (!this.userIds.containsKey((Object)InnerIds.getId((String)user.getToId()))) {
                    this.userIds.put((Object)InnerIds.getId((String)user.getToId()), (Object)this.userIds.size());
                }
                row = (Integer)this.userIds.get((Object)InnerIds.getId((String)user.getToId()));
                int col = (Integer)this.userIds.get((Object)InnerIds.getId((String)user.getToId()));
                relationshipTable.put((Object)row, (Object)col, (Object)1.0);
                rColMap.put((Object)col, (Object)row);
            }
        }
        for (User user : this.dataSet.getInteractions()) {
            long timestamp;
            String itemId = user.getItemId();
            String userId = user.getUserId();
            String rating = user.getValue();
            int row2 = this.userIds.containsKey((Object)InnerIds.getId((String)userId)) ? ((Integer)this.userIds.get((Object)InnerIds.getId((String)userId))).intValue() : this.userIds.size();
            this.userIds.put((Object)InnerIds.getId((String)userId), (Object)row2);
            int col = this.itemIds.containsKey((Object)InnerIds.getId((String)itemId)) ? ((Integer)this.itemIds.get((Object)InnerIds.getId((String)itemId))).intValue() : this.itemIds.size();
            this.itemIds.put((Object)InnerIds.getId((String)itemId), (Object)col);
            Double r = Double.valueOf(rating);
            if (r.isNaN()) {
                r = 1.0;
            }
            dataTable.put((Object)row2, (Object)col, (Object)r);
            colMap.put((Object)col, (Object)row2);
            this.scaleDist.add((Object)r);
            if (user.getTimeStamp() == null) continue;
            if (timeTable == null) {
                timeTable = HashBasedTable.create();
            }
            if (this.minTimestamp > (timestamp = user.getTimeStamp().getTime())) {
                this.minTimestamp = timestamp;
            }
            if (this.maxTimestamp < timestamp) {
                this.maxTimestamp = timestamp;
            }
            timeTable.put((Object)row2, (Object)col, (Object)timestamp);
        }
        this.numRatings = this.scaleDist.size();
        this.ratingScale = new ArrayList<Double>(this.scaleDist.elementSet());
        Collections.sort(this.ratingScale);
        int numRows = this.numUsers();
        int numCols = this.numItems();
        double minRate = this.ratingScale.get(0);
        double d = epsilon = minRate == 0.0 ? this.ratingScale.get(1) - minRate : 0.0;
        if (epsilon > 0.0) {
            int im = this.ratingScale.size();
            for (int i = 0; i < im; ++i) {
                double val = this.ratingScale.get(i);
                this.ratingScale.set(i, val + epsilon);
            }
            for (int row3 = 0; row3 < numRows; ++row3) {
                for (int col = 0; col < numCols; ++col) {
                    if (!dataTable.contains((Object)row3, (Object)col)) continue;
                    dataTable.put((Object)row3, (Object)col, (Object)((Double)dataTable.get((Object)row3, (Object)col) + epsilon));
                }
            }
        }
        this.rateMatrix = new SparseMatrix(numRows, numCols, (Table<Integer, Integer, ? extends Number>)dataTable, (Multimap<Integer, Integer>)colMap);
        if (timeTable != null) {
            this.timeMatrix = new SparseMatrix(numRows, numCols, (Table<Integer, Integer, ? extends Number>)timeTable, (Multimap<Integer, Integer>)colMap);
        }
        if (relationshipTable != null) {
            this.relationshipMatrix = new SparseMatrix(numRows, numRows, (Table<Integer, Integer, ? extends Number>)relationshipTable, (Multimap<Integer, Integer>)rColMap);
        }
        dataTable = null;
        timeTable = null;
        relationshipTable = null;
        return new SparseMatrix[]{this.rateMatrix, this.timeMatrix, this.relationshipMatrix};
    }

    public SparseMatrix[] readTensor() throws Exception {
        double epsilon;
        int d;
        int[] dims = null;
        int numDims = 3;
        List[] ndLists = null;
        Set[] ndSets = null;
        ArrayList<Double> vals = new ArrayList<Double>();
        for (Interaction interaction : this.dataSet.getInteractions()) {
            if (dims == null) {
                numDims = 2;
                dims = new int[numDims];
                ndLists = new List[numDims];
                ndSets = new Set[numDims];
                for (d = 0; d < numDims; ++d) {
                    ndLists[d] = new ArrayList();
                    ndSets[d] = new HashSet();
                }
            }
            int row = this.userIds.containsKey((Object)InnerIds.getId((String)interaction.getUserId())) ? ((Integer)this.userIds.get((Object)InnerIds.getId((String)interaction.getUserId()))).intValue() : this.userIds.size();
            this.userIds.put((Object)InnerIds.getId((String)interaction.getUserId()), (Object)row);
            ndLists[0].add(row);
            ndSets[0].add(row);
            int col = this.itemIds.containsKey((Object)InnerIds.getId((String)interaction.getItemId())) ? ((Integer)this.itemIds.get((Object)InnerIds.getId((String)interaction.getItemId()))).intValue() : this.itemIds.size();
            this.itemIds.put((Object)InnerIds.getId((String)interaction.getItemId()), (Object)col);
            ndLists[1].add(col);
            ndSets[1].add(col);
            double rate = Double.parseDouble(interaction.getValue());
            vals.add(rate);
            this.scaleDist.add((Object)rate);
        }
        this.numRatings = this.scaleDist.size();
        this.ratingScale = new ArrayList<Double>(this.scaleDist.elementSet());
        Collections.sort(this.ratingScale);
        double minRate = this.ratingScale.get(0);
        double d2 = epsilon = minRate == 0.0 ? this.ratingScale.get(1) - minRate : 0.0;
        if (epsilon > 0.0) {
            int i;
            int im = this.ratingScale.size();
            for (i = 0; i < im; ++i) {
                double val = this.ratingScale.get(i);
                this.ratingScale.set(i, val + epsilon);
            }
            for (i = 0; i < vals.size(); ++i) {
                vals.set(i, (Double)vals.get(i) + epsilon);
            }
        }
        for (d = 0; d < numDims; ++d) {
            dims[d] = ndSets[d].size();
        }
        this.rateTensor = new SparseTensor(dims, ndLists, vals);
        return new SparseMatrix[]{this.rateTensor.rateMatrix(), null};
    }

    public int numUsers() {
        return this.userIds.size();
    }

    public int numItems() {
        return this.itemIds.size();
    }

    public int numRatings() {
        return this.numRatings;
    }

    public int numDays() {
        return (int)TimeUnit.MILLISECONDS.toDays(this.maxTimestamp - this.minTimestamp);
    }

    public int getUserId(String rawId) {
        return (Integer)this.userIds.get((Object)InnerIds.getId((String)rawId));
    }

    public int getUserId(int innerId) {
        if (this.idUsers == null) {
            this.idUsers = this.userIds.inverse();
        }
        return (Integer)this.idUsers.get((Object)innerId);
    }

    public int getItemId(String rawId) {
        return (Integer)this.itemIds.get((Object)InnerIds.getId((String)rawId));
    }

    public int getItemId(int innerId) {
        if (this.idItems == null) {
            this.idItems = this.itemIds.inverse();
        }
        return (Integer)this.idItems.get((Object)innerId);
    }

    public SparseMatrix getRateMatrix() {
        return this.rateMatrix;
    }

    public SparseMatrix getRelationshipMatrix() {
        return this.relationshipMatrix;
    }

    public List<Double> getRatingScale() {
        return this.ratingScale;
    }

    public BiMap<Integer, Integer> getUserIds() {
        return this.userIds;
    }

    public BiMap<Integer, Integer> getItemIds() {
        return this.itemIds;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public SparseTensor getRateTensor() {
        return this.rateTensor;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }
}

