/*
 * Decompiled with CFR 0.152.
 */
package librec.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import librec.data.DenseVector;
import librec.data.VectorEntry;
import librec.util.Stats;

public class SparseVector
implements Iterable<VectorEntry>,
Serializable {
    private static final long serialVersionUID = 1151609203685872657L;
    protected int capacity;
    protected double[] data;
    protected int[] index;
    protected int count;

    public SparseVector(int capcity) {
        this.capacity = capcity;
        this.data = new double[0];
        this.count = 0;
        this.index = new int[0];
    }

    public SparseVector(int capcity, double[] array) {
        this(capcity);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0.0) continue;
            this.set(i, array[i]);
        }
    }

    public SparseVector(SparseVector sv) {
        this(sv.capacity, sv.data);
    }

    public boolean contains(int idx) {
        return Arrays.binarySearch(this.index, idx) >= 0;
    }

    public double[] getData() {
        double[] res = new double[this.count];
        for (int i = 0; i < this.count; ++i) {
            res[i] = this.data[i];
        }
        return res;
    }

    public int[] getIndex() {
        int[] res = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            res[i] = this.index[i];
        }
        return res;
    }

    public List<Integer> getIndexList() {
        ArrayList<Integer> res = new ArrayList<Integer>((int)((double)this.count * 1.5));
        for (int i = 0; i < this.count; ++i) {
            res.add(this.index[i]);
        }
        return res;
    }

    public int getCount() {
        return this.count;
    }

    public void set(int idx, double val) {
        this.check(idx);
        int i = this.getIndex(idx);
        this.data[i] = val;
    }

    public void add(int idx, double val) {
        int i;
        this.check(idx);
        int n = i = this.getIndex(idx);
        this.data[n] = this.data[n] + val;
    }

    public double get(int idx) {
        this.check(idx);
        int i = Arrays.binarySearch(this.index, 0, this.count, idx);
        return i >= 0 ? this.data[i] : 0.0;
    }

    public double inner(SparseVector vec) {
        double res = 0.0;
        for (int idx : this.getIndex()) {
            if (!vec.contains(idx)) continue;
            res += this.get(idx) * vec.get(idx);
        }
        return res;
    }

    public double inner(DenseVector vec) {
        double res = 0.0;
        for (int idx : this.getIndex()) {
            res += this.get(idx) * vec.get(idx);
        }
        return res;
    }

    public double sum() {
        return Stats.sum(this.data);
    }

    public double mean() {
        return this.sum() / (double)this.count;
    }

    public int size() {
        int num = 0;
        for (VectorEntry ve : this) {
            if (ve.get() == 0.0) continue;
            ++num;
        }
        return num;
    }

    protected void check(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("index is negative (" + idx + ")");
        }
        if (idx >= this.capacity) {
            throw new IndexOutOfBoundsException("index >= size (" + idx + " >= " + this.capacity + ")");
        }
    }

    private int getIndex(int idx) {
        int i = Arrays.binarySearch(this.index, 0, this.count, idx);
        if (i >= 0 && this.index[i] == idx) {
            return i;
        }
        int[] newIndex = this.index;
        double[] newData = this.data;
        i = -(i + 1);
        if (++this.count > this.data.length) {
            int newLength = this.data.length != 0 ? this.data.length << 1 : 1;
            newIndex = new int[newLength];
            newData = new double[newLength];
            System.arraycopy(this.index, 0, newIndex, 0, i);
            System.arraycopy(this.data, 0, newData, 0, i);
        }
        System.arraycopy(this.index, i, newIndex, i + 1, this.count - i - 1);
        System.arraycopy(this.data, i, newData, i + 1, this.count - i - 1);
        newIndex[i] = idx;
        newData[i] = 0.0;
        this.index = newIndex;
        this.data = newData;
        return i;
    }

    @Override
    public Iterator<VectorEntry> iterator() {
        return new SparseVecIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%d\t%d\n", this.capacity, this.count));
        for (VectorEntry ve : this) {
            if (ve.get() == 0.0) continue;
            sb.append(String.format("%d\t%f\n", ve.index(), ve.get()));
        }
        return sb.toString();
    }

    public Map<Integer, Double> toMap() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i = 0; i < this.count; ++i) {
            int idx = this.index[i];
            double val = this.data[i];
            if (val == 0.0) continue;
            map.put(idx, val);
        }
        return map;
    }

    private class SparseVecEntry
    implements VectorEntry {
        private int cursor;

        private SparseVecEntry() {
        }

        public void update(int cursor) {
            this.cursor = cursor;
        }

        @Override
        public int index() {
            return SparseVector.this.index[this.cursor];
        }

        @Override
        public double get() {
            return SparseVector.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            SparseVector.this.data[this.cursor] = value;
        }
    }

    private class SparseVecIterator
    implements Iterator<VectorEntry> {
        private int cursor;
        private final SparseVecEntry entry;

        private SparseVecIterator() {
            this.entry = new SparseVecEntry();
        }

        @Override
        public boolean hasNext() {
            return this.cursor < SparseVector.this.count;
        }

        @Override
        public VectorEntry next() {
            this.entry.update(this.cursor);
            ++this.cursor;
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

