/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import librec.data.SparseVector;
import librec.intf.IterativeRecommender;
import librec.util.Randoms;

public class BPR
extends IterativeRecommender {
    public BPR() {
        this.isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.userCache = this.trainMatrix.rowCache(this.guavaCacheSpec);
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            int smax = this.numUsers * 100;
            for (int s = 0; s < smax; ++s) {
                SparseVector pu;
                int u = 0;
                int i = 0;
                int j = 0;
                while ((pu = (SparseVector)this.userCache.get((Object)(u = Randoms.uniform(this.numUsers)))).getCount() == 0) {
                }
                int[] is = pu.getIndex();
                i = is[Randoms.uniform(is.length)];
                while (pu.contains(j = Randoms.uniform(this.numItems))) {
                }
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                for (int f = 0; f < this.numFactors; ++f) {
                    double puf = this.P.get(u, f);
                    double qif = this.Q.get(i, f);
                    double qjf = this.Q.get(j, f);
                    this.P.add(u, f, this.lRate * (cmg * (qif - qjf) - this.regU * puf));
                    this.Q.add(i, f, this.lRate * (cmg * puf - this.regI * qif));
                    this.Q.add(j, f, this.lRate * (cmg * -puf - this.regI * qjf));
                    this.loss += this.regU * puf * puf + this.regI * qif * qif + this.regI * qjf * qjf;
                }
            }
            if (this.isConverged(iter)) break;
        }
    }
}

