/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.google.common.collect.Table;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import java.util.Iterator;
import java.util.List;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;
import librec.util.Randoms;

@Configurations(value={@Configuration(key="rho", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double), @Configuration(key="alpha", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Double)})
public class FISMrmse
extends IterativeRecommender {
    public double rho;
    public double alpha;
    public int nnz;

    public FISMrmse() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        this.P = new DenseMatrix(this.numItems, this.numFactors);
        this.Q = new DenseMatrix(this.numItems, this.numFactors);
        this.P.init(0.01);
        this.Q.init(0.01);
        this.userBias = new DenseVector(this.numUsers);
        this.itemBias = new DenseVector(this.numItems);
        this.userBias.init(0.01);
        this.itemBias.init(0.01);
        this.nnz = this.trainMatrix.size();
        this.userItemsCache = this.trainMatrix.rowColumnsCache(this.guavaCacheSpec);
    }

    @Override
    public void buildModel() throws Exception {
        int sampleSize = (int)(this.rho * (double)this.nnz);
        int totalSize = this.numUsers * this.numItems;
        for (int iter = 1; iter <= this.numIters; ++iter) {
            this.loss = 0.0;
            DenseMatrix PS = new DenseMatrix(this.numItems, this.numFactors);
            DenseMatrix QS = new DenseMatrix(this.numItems, this.numFactors);
            Table<Integer, Integer, Double> R = this.trainMatrix.getDataTable();
            List<Integer> indices = Randoms.randInts(sampleSize, 0, totalSize - this.nnz);
            int index = 0;
            int count = 0;
            boolean isDone = false;
            for (int u = 0; u < this.numUsers; ++u) {
                for (int j = 0; j < this.numItems; ++j) {
                    double ruj = this.trainMatrix.get(u, j);
                    if (ruj != 0.0 || count++ != indices.get(index)) continue;
                    R.put((Object)u, (Object)j, (Object)0.0);
                    if (++index < indices.size()) continue;
                    isDone = true;
                    break;
                }
                if (isDone) break;
            }
            for (Table.Cell cell : R.cellSet()) {
                int u = (Integer)cell.getRowKey();
                int j = (Integer)cell.getColumnKey();
                double ruj = (Double)cell.getValue();
                SparseVector Ru = this.trainMatrix.row(u);
                double bu = this.userBias.get(u);
                double bj = this.itemBias.get(j);
                double sum_ij = 0.0;
                int cnt = 0;
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    if (i == j) continue;
                    sum_ij += DenseMatrix.rowMult(this.P, i, this.Q, j);
                    ++cnt;
                }
                double wu = cnt > 0 ? Math.pow(cnt, -this.alpha) : 0.0;
                double puj = bu + bj + wu * sum_ij;
                double euj = puj - ruj;
                this.loss += euj * euj;
                this.userBias.add(u, -this.lRate * (euj + this.regB * bu));
                this.itemBias.add(j, -this.lRate * (euj + this.regB * bj));
                this.loss += this.regB * bu * bu + this.regB * bj * bj;
                for (int f = 0; f < this.numFactors; ++f) {
                    double qjf = this.Q.get(j, f);
                    double sum_i = 0.0;
                    for (VectorEntry ve : Ru) {
                        int i = ve.index();
                        if (i == j) continue;
                        sum_i += this.P.get(i, f);
                    }
                    double delta = euj * wu * sum_i + this.regI * qjf;
                    QS.add(j, f, -this.lRate * delta);
                    this.loss += this.regI * qjf * qjf;
                }
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    if (i == j) continue;
                    for (int f = 0; f < this.numFactors; ++f) {
                        double pif = this.P.get(i, f);
                        double delta = euj * wu * this.Q.get(j, f) + this.regI * pif;
                        PS.add(i, f, -this.lRate * delta);
                        this.loss += this.regI * pif * pif;
                    }
                }
            }
            this.P = this.P.add(PS);
            this.Q = this.Q.add(QS);
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    public double predict(int u, int j) throws Exception {
        double pred = this.userBias.get(u) + this.itemBias.get(j);
        double sum = 0.0;
        int count = 0;
        List items = (List)this.userItemsCache.get((Object)u);
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i == j) continue;
            sum += DenseMatrix.rowMult(this.P, i, this.Q, j);
            ++count;
        }
        double wu = count > 0 ? Math.pow(count, -this.alpha) : 0.0;
        return pred + wu * sum;
    }
}

