/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import java.util.HashMap;
import java.util.List;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.IterativeRecommender;

@Configuration(key="isSupportWeight", requirement=ConfigurationItem.ConfigurationItemRequirementType.Required, type=ConfigurationItem.ConfigurationItemType.Boolean, description="whether support based weighting is used ($s_i=|U_i|$) or not ($s_i=1$)")
public class RankALS
extends IterativeRecommender {
    public boolean isSupportWeight;
    private DenseVector s;
    private double sum_s;

    public RankALS() {
        this.isRankingPred = true;
    }

    @Override
    public void initModel() throws Exception {
        super.initModel();
        this.s = new DenseVector(this.numItems);
        this.sum_s = 0.0;
        for (int i = 0; i < this.numItems; ++i) {
            double si = this.isSupportWeight ? (double)this.trainMatrix.columnSize(i) : 1.0;
            this.s.set(i, si);
            this.sum_s += si;
        }
    }

    @Override
    public void buildModel() throws Exception {
        for (int iter = 1; iter < this.numIters; ++iter) {
            Object y;
            SparseVector Ru;
            Object sum_cqr;
            Object qj;
            DenseVector sum_sq = new DenseVector(this.numFactors);
            DenseMatrix sum_sqq = new DenseMatrix(this.numFactors, this.numFactors);
            for (int j = 0; j < this.numItems; ++j) {
                qj = this.Q.row(j);
                double sj = this.s.get(j);
                sum_sq = sum_sq.add(((DenseVector)qj).scale(sj));
                sum_sqq = sum_sqq.add(((DenseVector)qj).outer((DenseVector)qj).scale(sj));
            }
            List<Integer> cus = this.trainMatrix.rows();
            qj = cus.iterator();
            while (qj.hasNext()) {
                int u = (Integer)qj.next();
                DenseMatrix sum_cqq = new DenseMatrix(this.numFactors, this.numFactors);
                DenseVector sum_cq = new DenseVector(this.numFactors);
                sum_cqr = new DenseVector(this.numFactors);
                DenseVector sum_sqr = new DenseVector(this.numFactors);
                Ru = this.trainMatrix.row(u);
                double sum_c = Ru.getCount();
                double sum_sr = 0.0;
                double sum_cr = 0.0;
                for (VectorEntry ve : Ru) {
                    int i = ve.index();
                    double rui = ve.get();
                    DenseVector qi = this.Q.row(i);
                    sum_cqq = sum_cqq.add(qi.outer(qi));
                    sum_cq = sum_cq.add(qi);
                    sum_cqr = ((DenseVector)sum_cqr).add(qi.scale(rui));
                    double si = this.s.get(i);
                    sum_sr += si * rui;
                    sum_cr += rui;
                    sum_sqr = sum_sqr.add(qi.scale(si * rui));
                }
                DenseMatrix M = sum_cqq.scale(this.sum_s).minus(sum_cq.outer(sum_sq)).minus(sum_sq.outer(sum_cq)).add(sum_sqq.scale(sum_c));
                y = ((DenseVector)sum_cqr).scale(this.sum_s).minus(sum_cq.scale(sum_sr)).minus(sum_sq.scale(sum_cr)).add(sum_sqr.scale(sum_c));
                DenseVector pu = M.inv().mult((DenseVector)y);
                this.P.setRow(u, pu);
            }
            HashMap<Integer, Double> m_sum_sr = new HashMap<Integer, Double>();
            HashMap<Integer, Double> m_sum_cr = new HashMap<Integer, Double>();
            HashMap<Integer, Double> m_sum_c = new HashMap<Integer, Double>();
            HashMap<Integer, DenseVector> m_sum_cq = new HashMap<Integer, DenseVector>();
            sum_cqr = cus.iterator();
            while (sum_cqr.hasNext()) {
                int u = sum_cqr.next();
                Ru = this.trainMatrix.row(u);
                double sum_sr = 0.0;
                double sum_cr = 0.0;
                double sum_c = Ru.getCount();
                DenseVector sum_cq = new DenseVector(this.numFactors);
                for (VectorEntry ve : Ru) {
                    int j = ve.index();
                    double ruj = ve.get();
                    double sj = this.s.get(j);
                    sum_sr += sj * ruj;
                    sum_cr += ruj;
                    sum_cq = sum_cq.add(this.Q.row(j));
                }
                m_sum_sr.put(u, sum_sr);
                m_sum_cr.put(u, sum_cr);
                m_sum_c.put(u, sum_c);
                m_sum_cq.put(u, sum_cq);
            }
            for (int i = 0; i < this.numItems; ++i) {
                DenseMatrix sum_cpp = new DenseMatrix(this.numFactors, this.numFactors);
                DenseMatrix sum_p_p_c = new DenseMatrix(this.numFactors, this.numFactors);
                DenseVector sum_p_p_cq = new DenseVector(this.numFactors);
                DenseVector sum_cpr = new DenseVector(this.numFactors);
                DenseVector sum_c_sr_p = new DenseVector(this.numFactors);
                DenseVector sum_cr_p = new DenseVector(this.numFactors);
                DenseVector sum_p_r_c = new DenseVector(this.numFactors);
                double si = this.s.get(i);
                y = cus.iterator();
                while (y.hasNext()) {
                    int u = (Integer)y.next();
                    DenseVector pu = this.P.row(u);
                    double rui = this.trainMatrix.get(u, i);
                    DenseMatrix pp = pu.outer(pu);
                    sum_cpp = sum_cpp.add(pp);
                    sum_p_p_cq = sum_p_p_cq.add(pp.mult((DenseVector)m_sum_cq.get(u)));
                    sum_p_p_c = sum_p_p_c.add(pp.scale((Double)m_sum_c.get(u)));
                    sum_cr_p = sum_cr_p.add(pu.scale((Double)m_sum_cr.get(u)));
                    if (!(rui > 0.0)) continue;
                    sum_cpr = sum_cpr.add(pu.scale(rui));
                    sum_c_sr_p = sum_c_sr_p.add(pu.scale((Double)m_sum_sr.get(u)));
                    sum_p_r_c = sum_p_r_c.add(pu.scale(rui * (Double)m_sum_c.get(u)));
                }
                DenseMatrix M = sum_cpp.scale(this.sum_s).add(sum_p_p_c.scale(si));
                DenseVector y2 = sum_cpp.mult(sum_sq).add(sum_cpr.scale(this.sum_s)).minus(sum_c_sr_p).add(sum_p_p_cq.scale(si)).minus(sum_cr_p.scale(si)).add(sum_p_r_c.scale(si));
                DenseVector qi = M.inv().mult(y2);
                this.Q.setRow(i, qi);
            }
        }
    }
}

