/*
 * Decompiled with CFR 0.152.
 */
package librec.rating;

import com.google.common.collect.HashBasedTable;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.MatrixEntry;
import librec.intf.GraphicRecommender;
import librec.util.Gamma;

public class URP
extends GraphicRecommender {
    private int[][][] Nkir;
    private double[][][] PkirSum;
    protected double[][][] Pkir;

    @Override
    public void initModel() throws Exception {
        this.PukSum = new DenseMatrix(this.numUsers, this.numFactors);
        this.PkirSum = new double[this.numFactors][this.numItems][this.numLevels];
        this.Nuk = new DenseMatrix(this.numUsers, this.numFactors);
        this.Nu = new DenseVector(this.numUsers);
        this.Nkir = new int[this.numFactors][this.numItems][this.numLevels];
        this.Nki = new DenseMatrix(this.numFactors, this.numItems);
        this.alpha = new DenseVector(this.numFactors);
        this.alpha.setAll(this.initAlpha);
        this.beta = new DenseVector(this.numLevels);
        this.beta.setAll(this.initBeta);
        this.z = HashBasedTable.create();
        for (MatrixEntry me : this.trainMatrix) {
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = ratingScale.indexOf(rui);
            int t = (int)(Math.random() * (double)this.numFactors);
            this.z.put((Object)u, (Object)i, (Object)t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] + 1;
            this.Nki.add(t, i, 1.0);
        }
    }

    @Override
    protected void eStep() {
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (MatrixEntry me : this.trainMatrix) {
            int k;
            int u = me.row();
            int i = me.column();
            double rui = me.get();
            int r = (int)(rui / this.minRate - 1.0);
            int t = (Integer)this.z.get((Object)u, (Object)i);
            this.Nuk.add(u, t, -1.0);
            this.Nu.add(u, -1.0);
            int[] nArray = this.Nkir[t][i];
            int n = r;
            nArray[n] = nArray[n] - 1;
            this.Nki.add(t, i, -1.0);
            double[] p = new double[this.numFactors];
            for (k = 0; k < this.numFactors; ++k) {
                p[k] = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha) * ((double)this.Nkir[k][i][r] + this.beta.get(r)) / (this.Nki.get(k, i) + sumBeta);
            }
            for (k = 1; k < p.length; ++k) {
                int n2 = k;
                p[n2] = p[n2] + p[k - 1];
            }
            double rand = Math.random() * p[this.numFactors - 1];
            for (t = 0; t < p.length && !(rand < p[t]); ++t) {
            }
            this.z.put((Object)u, (Object)i, (Object)t);
            this.Nuk.add(u, t, 1.0);
            this.Nu.add(u, 1.0);
            int[] nArray2 = this.Nkir[t][i];
            int n3 = r;
            nArray2[n3] = nArray2[n3] + 1;
            this.Nki.add(t, i, 1.0);
        }
    }

    @Override
    protected void mStep() {
        double denominator;
        double numerator;
        double sumAlpha = this.alpha.sum();
        double sumBeta = this.beta.sum();
        for (int k = 0; k < this.numFactors; ++k) {
            double ak = this.alpha.get(k);
            numerator = 0.0;
            denominator = 0.0;
            for (int u = 0; u < this.numUsers; ++u) {
                numerator += Gamma.digamma(this.Nuk.get(u, k) + ak) - Gamma.digamma(ak);
                denominator += Gamma.digamma(this.Nu.get(u) + sumAlpha) - Gamma.digamma(sumAlpha);
            }
            if (numerator == 0.0) continue;
            this.alpha.set(k, ak * (numerator / denominator));
        }
        for (int r = 0; r < this.numLevels; ++r) {
            double br = this.beta.get(r);
            numerator = 0.0;
            denominator = 0.0;
            for (int i = 0; i < this.numItems; ++i) {
                for (int k = 0; k < this.numFactors; ++k) {
                    numerator += Gamma.digamma((double)this.Nkir[k][i][r] + br) - Gamma.digamma(br);
                    denominator += Gamma.digamma(this.Nki.get(k, i) + sumBeta) - Gamma.digamma(sumBeta);
                }
            }
            if (numerator == 0.0) continue;
            this.beta.set(r, br * (numerator / denominator));
        }
    }

    @Override
    protected void readoutParams() {
        double val = 0.0;
        double sumAlpha = this.alpha.sum();
        for (int u = 0; u < this.numUsers; ++u) {
            for (int k = 0; k < this.numFactors; ++k) {
                val = (this.Nuk.get(u, k) + this.alpha.get(k)) / (this.Nu.get(u) + sumAlpha);
                this.PukSum.add(u, k, val);
            }
        }
        double sumBeta = this.beta.sum();
        for (int k = 0; k < this.numFactors; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                int r = 0;
                while (r < this.numLevels) {
                    val = ((double)this.Nkir[k][i][r] + this.beta.get(r)) / (this.Nki.get(k, i) + sumBeta);
                    double[] dArray = this.PkirSum[k][i];
                    int n = r++;
                    dArray[n] = dArray[n] + val;
                }
            }
        }
        ++this.numStats;
    }

    @Override
    protected void estimateParams() {
        this.Puk = this.PukSum.scale(1.0 / (double)this.numStats);
        this.Pkir = new double[this.numFactors][this.numItems][this.numLevels];
        for (int k = 0; k < this.numFactors; ++k) {
            for (int i = 0; i < this.numItems; ++i) {
                for (int r = 0; r < this.numLevels; ++r) {
                    this.Pkir[k][i][r] = this.PkirSum[k][i][r] / (double)this.numStats;
                }
            }
        }
    }

    @Override
    public double predict(int u, int i) throws Exception {
        double pred = 0.0;
        for (int r = 0; r < this.numLevels; ++r) {
            double rate = (Double)ratingScale.get(r);
            double prob = 0.0;
            for (int k = 0; k < this.numFactors; ++k) {
                prob += this.Puk.get(u, k) * this.Pkir[k][i][r];
            }
            pred += prob * rate;
        }
        return pred;
    }
}

