/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.splitter;

import com.recalot.common.Helper;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.FillableDataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Configuration(key="testPercentage", type=ConfigurationItem.ConfigurationItemType.Double, value="0.3", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description="")
public class TimeBasedDataSplitter
extends DataSplitter {
    private double testPercentage = 0.3;

    public DataSet[] split(DataSource source) throws BaseException {
        FillableDataSet[] result = new FillableDataSet[]{new FillableDataSet(), new FillableDataSet()};
        for (Item item : source.getItems()) {
            result[0].addItem(item);
            result[1].addItem(item);
        }
        for (Item item : source.getRelations()) {
            for (FillableDataSet dataSet : result) {
                dataSet.addRelation((Relation)item);
            }
        }
        for (Item item : source.getUsers()) {
            result[0].addUser((User)item);
            result[1].addUser((User)item);
            Interaction[] userInteractions = source.getInteractions(item.getId());
            HashMap<Interaction, Long> userRatingsWithTimeStamp = new HashMap<Interaction, Long>();
            for (Interaction r : userInteractions) {
                userRatingsWithTimeStamp.put(r, r.getTimeStamp().getTime());
            }
            Map sortedInteractions = Helper.sortByValueDescending(userRatingsWithTimeStamp);
            int counter = 1;
            double testInteractionCount = (double)userInteractions.length * this.testPercentage;
            for (Interaction r : sortedInteractions.keySet()) {
                if ((double)counter <= testInteractionCount) {
                    result[1].addInteraction(r);
                } else {
                    result[0].addInteraction(r);
                }
                ++counter;
            }
        }
        return result;
    }

    public String getKey() {
        return "time";
    }

    public String getId() {
        return "time";
    }

    public String getDescription() {
        return null;
    }

    public void close() throws IOException {
    }

    public double getTestPercentage() {
        return this.testPercentage;
    }

    public void setTestPercentage(double testPercentage) {
        this.testPercentage = testPercentage;
    }
}

