/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.controller.experiments;

import com.recalot.common.GenericControllerListener;
import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.DataSplitterBuilder;
import com.recalot.common.builder.MetricBuilder;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.controller.ExperimentsController;
import com.recalot.common.interfaces.controller.RecommenderController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.common.interfaces.model.data.DataAccess;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.experiment.DataSplitter;
import com.recalot.common.interfaces.model.experiment.Experiment;
import com.recalot.common.interfaces.model.experiment.ExperimentAccess;
import com.recalot.common.interfaces.model.experiment.Metric;
import com.recalot.common.interfaces.model.experiment.OnlineExperiment;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.interfaces.template.ExperimentTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;

public class ExperimentsController
implements com.recalot.common.interfaces.controller.ExperimentsController,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener<RecommenderBuilder> recommenderAccess;
    private final GenericServiceListener<ExperimentTemplate> templates;
    private final GenericServiceListener<DataAccess> dataAccess;
    private final GenericServiceListener<ExperimentAccess> experimentsAccess;
    private final GenericServiceListener<DataSplitterBuilder> dataSplitterAccess;
    private final GenericServiceListener<MetricBuilder> metricsListener;
    private final ContextProvider contextProvider;
    private final GenericControllerListener recommenderController;

    public ExperimentsController(BundleContext context) {
        this.context = context;
        this.recommenderAccess = new GenericServiceListener(context, RecommenderBuilder.class.getName());
        this.recommenderController = new GenericControllerListener(context, RecommenderController.class.getName());
        this.dataAccess = new GenericServiceListener(context, DataAccess.class.getName());
        this.experimentsAccess = new GenericServiceListener(context, ExperimentAccess.class.getName());
        this.dataSplitterAccess = new GenericServiceListener(context, DataSplitterBuilder.class.getName());
        this.templates = new GenericServiceListener(context, ExperimentTemplate.class.getName());
        this.metricsListener = new GenericServiceListener(context, MetricBuilder.class.getName());
        this.contextProvider = new ContextProvider(context);
        this.context.addServiceListener(this.recommenderAccess);
        this.context.addServiceListener((ServiceListener)this.recommenderController);
        this.context.addServiceListener(this.dataAccess);
        this.context.addServiceListener(this.experimentsAccess);
        this.context.addServiceListener(this.dataSplitterAccess);
        this.context.addServiceListener(this.templates);
        this.context.addServiceListener(this.metricsListener);
        this.context.addServiceListener((ServiceListener)this.contextProvider);
    }

    public TemplateResult process(RequestAction action, String templateKey, Map<String, String> param) throws BaseException {
        ExperimentTemplate template = (ExperimentTemplate)this.templates.getInstance(templateKey);
        TemplateResult result = null;
        try {
            switch ((ExperimentsController.ExperimentsRequestAction)action) {
                case CreateExperiment: {
                    result = this.createExperiment(template, param);
                    break;
                }
                case CreateOnlineExperiment: {
                    result = this.createOnlineExperiment(template, param);
                    break;
                }
                case DeleteExperiment: {
                    result = this.deleteExperiment(template, param);
                    break;
                }
                case DeleteOnlineExperiment: {
                    result = this.deleteOnlineExperiment(template, param);
                    break;
                }
                case GetExperiments: {
                    result = this.getExperiments(template, param);
                    break;
                }
                case GetOnlineExperiments: {
                    result = this.getOnlineExperiments(template, param);
                    break;
                }
                case GetRecommendationForOnlineExperiment: {
                    result = this.getRecommendationForOnlineExperiment(templateKey, param);
                    break;
                }
                case GetExperiment: {
                    result = this.getExperiment(template, param);
                    break;
                }
                case GetOnlineExperiment: {
                    result = this.getOnlineExperiment(template, param);
                    break;
                }
                case GetExperimentConfiguration: {
                    result = this.getExperiment(template, param);
                    break;
                }
                case GetMetrics: {
                    result = this.getMetrics(template, param);
                    break;
                }
                case GetMetric: {
                    result = this.getMetric(template, param);
                    break;
                }
                case GetSplitters: {
                    result = this.getSplitters(template, param);
                    break;
                }
                case GetSplitter: {
                    result = this.getSplitter(template, param);
                }
            }
        }
        catch (BaseException ex) {
            result = template.transform(ex);
        }
        return result;
    }

    private TemplateResult getRecommendationForOnlineExperiment(String templateKey, Map<String, String> param) throws BaseException {
        String experimentID = param.get(Helper.Keys.ExperimentId);
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        String recommenderId = access.getNextRecommenderForOnlineExperiment(experimentID, param);
        param.put(Helper.Keys.RecommenderId, recommenderId);
        return this.recommenderController.getFirstInstance().process((RequestAction)RecommenderController.RecommenderRequestAction.Recommend, templateKey, param);
    }

    private TemplateResult createOnlineExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        DataSource dataSource = dAccess.getDataSource(param.get(Helper.Keys.SourceId));
        return template.transform(access.createOnlineExperiment(dataSource, param));
    }

    private TemplateResult getOnlineExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        DataSource dataSource = dAccess.getDataSource(param.get(Helper.Keys.SourceId));
        return template.transform(access.getOnlineExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult getExperiments(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        List experiments = access.getExperiments();
        if (param.containsKey(Helper.Keys.State)) {
            Experiment.ExperimentState state = Experiment.ExperimentState.valueOf((String)param.get(Helper.Keys.State));
            ArrayList<Experiment> temp = new ArrayList<Experiment>();
            for (Experiment info : experiments) {
                if (info.getState() != state) continue;
                temp.add(info);
            }
            return template.transform(temp);
        }
        return template.transform(experiments);
    }

    private TemplateResult getOnlineExperiments(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        List experiments = access.getOnlineExperiments();
        if (param.containsKey(Helper.Keys.State)) {
            OnlineExperiment.ExperimentState state = OnlineExperiment.ExperimentState.valueOf((String)param.get(Helper.Keys.State));
            ArrayList<OnlineExperiment> temp = new ArrayList<OnlineExperiment>();
            for (OnlineExperiment info : experiments) {
                if (info.getState() != state) continue;
                temp.add(info);
            }
            return template.transformOnlineExperiments(temp);
        }
        return template.transformOnlineExperiments(experiments);
    }

    private TemplateResult createExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        String experimentId = param.get(Helper.Keys.ExperimentId);
        if (experimentId != null && !experimentId.isEmpty() && access.containsExperiment(experimentId)) {
            throw new AlreadyExistsException("An experiment with the id %s already exists.", experimentId);
        }
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        ArrayList<Object> recommender = new ArrayList<Object>();
        String recommenderId = param.get(Helper.Keys.RecommenderId);
        if (recommenderId != null) {
            Map keyIds = Helper.splitIdKeyConfig((String)recommenderId);
            for (String key : keyIds.keySet()) {
                param.put(key + "." + Helper.Keys.ID, key);
                param.put(key + "." + Helper.Keys.SourceId, param.get(Helper.Keys.SourceId));
                recommender.add(((RecommenderBuilder)this.recommenderAccess.getInstance((String)keyIds.get(key))).createInstance(key, key, param));
            }
        }
        DataSource dataSource = dAccess.getDataSource(param.get(Helper.Keys.SourceId));
        String metricIds = param.get(Helper.Keys.MetricIDs);
        HashMap<String, Metric[]> metrics = new HashMap<String, Metric[]>();
        if (metricIds != null) {
            Map keyIds = Helper.splitIdKeyConfig((String)metricIds);
            for (Recommender recommender2 : recommender) {
                ArrayList<Object> m = new ArrayList<Object>();
                for (String key : keyIds.keySet()) {
                    m.add(((MetricBuilder)this.metricsListener.getInstance((String)keyIds.get(key))).createInstance(key, key, param));
                }
                metrics.put(recommender2.getId(), m.toArray(new Metric[m.size()]));
            }
        }
        DataSplitterBuilder splitterBuilder = (DataSplitterBuilder)this.dataSplitterAccess.getInstance(param.get(Helper.Keys.DataSplitterId));
        DataSplitter splitter = (DataSplitter)splitterBuilder.createInstance(param.get(Helper.Keys.DataSplitterId), param.get(Helper.Keys.DataSplitterId), param);
        return template.transform(access.createExperiment(recommender.toArray(new Recommender[recommender.size()]), dataSource, splitter, metrics, this.contextProvider, param));
    }

    private TemplateResult deleteExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        return template.transform(access.deleteExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult deleteOnlineExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        return template.transform(access.deleteOnlineExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult getExperiment(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        ExperimentAccess access = (ExperimentAccess)this.experimentsAccess.getFirstInstance();
        return template.transform(access.getExperiment(param.get(Helper.Keys.ExperimentId)));
    }

    private TemplateResult getSplitter(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transform((DataSplitterBuilder)this.dataSplitterAccess.getInstance(param.get(Helper.Keys.DataSplitterId)));
    }

    private TemplateResult getSplitters(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transformSplitters((List)this.dataSplitterAccess.getAll());
    }

    private TemplateResult getMetrics(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transformMetrics((List)this.metricsListener.getAll());
    }

    private TemplateResult getMetric(ExperimentTemplate template, Map<String, String> param) throws BaseException {
        return template.transform((MetricBuilder)this.metricsListener.getInstance(param.get(Helper.Keys.MetricIDs)));
    }

    @Override
    public void close() throws IOException {
        if (this.recommenderAccess != null) {
            this.context.removeServiceListener(this.recommenderAccess);
        }
        if (this.dataAccess != null) {
            this.context.removeServiceListener(this.dataAccess);
        }
        if (this.templates != null) {
            this.context.removeServiceListener(this.templates);
        }
        if (this.experimentsAccess != null) {
            this.context.removeServiceListener(this.experimentsAccess);
        }
        if (this.dataSplitterAccess != null) {
            this.context.removeServiceListener(this.dataSplitterAccess);
        }
        if (this.metricsListener != null) {
            this.context.removeServiceListener(this.metricsListener);
        }
    }
}

