/*
 * Decompiled with CFR 0.152.
 */
package flexjson.transformer;

import flexjson.transformer.Transformer;
import java.util.Arrays;
import java.util.HashMap;

public class TypeTransformerMap
extends HashMap<Class, Transformer> {
    private TypeTransformerMap parentTransformerMap;

    public TypeTransformerMap() {
    }

    public TypeTransformerMap(TypeTransformerMap parentTransformerMap) {
        this.parentTransformerMap = parentTransformerMap;
    }

    public Transformer getTransformer(Object key) {
        Transformer transformer = this.findTransformer(key == null ? Void.TYPE : key.getClass(), key == null ? Void.TYPE : key.getClass());
        if (transformer == null && this.parentTransformerMap != null && (transformer = this.parentTransformerMap.getTransformer(key)) != null) {
            this.updateTransformers(key == null ? Void.TYPE : key.getClass(), transformer);
        }
        return transformer;
    }

    Transformer findTransformer(Class key, Class originalKey) {
        if (key == null) {
            return null;
        }
        if (this.containsKey(key)) {
            if (key != originalKey) {
                return this.updateTransformers(originalKey, (Transformer)this.get(key));
            }
            return (Transformer)this.get(key);
        }
        if (key.isArray()) {
            return this.updateTransformers(originalKey, (Transformer)this.get(Arrays.class));
        }
        for (Class<?> interfaze : key.getInterfaces()) {
            if (this.containsKey(interfaze)) {
                return this.updateTransformers(originalKey, (Transformer)this.get(interfaze));
            }
            Transformer t = this.findTransformer(interfaze, originalKey);
            if (t == null) continue;
            return t;
        }
        return this.findTransformer(key.getSuperclass(), originalKey);
    }

    private Transformer updateTransformers(Class key, Transformer transformer) {
        if (transformer != null) {
            this.put(key, transformer);
        }
        return transformer;
    }
}

