/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.controller.recommendations;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.communication.Message;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.TemplateResult;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.Context;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.context.UserContext;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.exceptions.NotReadyException;
import com.recalot.common.interfaces.controller.RecommenderController;
import com.recalot.common.interfaces.controller.RequestAction;
import com.recalot.common.interfaces.model.data.DataAccess;
import com.recalot.common.interfaces.model.data.DataInformation;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.interfaces.model.rec.RecommenderAccess;
import com.recalot.common.interfaces.model.rec.RecommenderInformation;
import com.recalot.common.interfaces.template.RecommenderTemplate;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;

public class RecommenderController
implements com.recalot.common.interfaces.controller.RecommenderController,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener recommenderAccess;
    private final GenericServiceListener templates;
    private final GenericServiceListener dataAccess;
    private final ContextProvider contextProvider;

    public RecommenderController(BundleContext context) {
        this.context = context;
        this.recommenderAccess = new GenericServiceListener(context, RecommenderAccess.class.getName());
        this.dataAccess = new GenericServiceListener(context, DataAccess.class.getName());
        this.templates = new GenericServiceListener(context, RecommenderTemplate.class.getName());
        this.contextProvider = new ContextProvider(context);
        this.context.addServiceListener((ServiceListener)this.recommenderAccess);
        this.context.addServiceListener((ServiceListener)this.dataAccess);
        this.context.addServiceListener((ServiceListener)this.templates);
        this.context.addServiceListener((ServiceListener)this.contextProvider);
    }

    public TemplateResult process(RequestAction action, String templateKey, Map<String, String> param) throws BaseException {
        RecommenderTemplate template = (RecommenderTemplate)this.templates.getInstance(templateKey);
        TemplateResult result = null;
        try {
            switch ((RecommenderController.RecommenderRequestAction)action) {
                case CreateRecommender: {
                    result = this.createRecommender(template, param);
                    break;
                }
                case Recommend: {
                    result = this.recommend(template, param);
                    break;
                }
                case GetRecommender: {
                    result = this.getRecommender(template, param);
                    break;
                }
                case GetRecommenderBuilder: {
                    result = this.getRecommenderBuilder(template, param);
                    break;
                }
                case GetRecommenders: {
                    result = this.getRecommenders(template, param);
                    break;
                }
                case UpdateRecommender: {
                    result = this.updateRecommender(template, param);
                    break;
                }
                case DeleteRecommender: {
                    result = this.deleteRecommender(template, param);
                }
            }
        }
        catch (BaseException ex) {
            result = template.transform(ex);
        }
        return result;
    }

    private TemplateResult getRecommenders(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        RecommenderInformation[] recommenders = access.getRecommenders();
        if (param.containsKey(Helper.Keys.State)) {
            RecommenderInformation.RecommenderState state = RecommenderInformation.RecommenderState.valueOf((String)param.get(Helper.Keys.State));
            ArrayList<RecommenderInformation> temp = new ArrayList<RecommenderInformation>();
            for (RecommenderInformation info : recommenders) {
                if (info.getState() != state) continue;
                temp.add(info);
            }
            return template.transform(temp.toArray(new RecommenderInformation[temp.size()]));
        }
        return template.transform(recommenders);
    }

    private TemplateResult deleteRecommender(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        Message message = access.deleteRecommender(param.get(Helper.Keys.RecommenderId));
        return template.transform(message);
    }

    private TemplateResult getRecommender(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        Recommender recommender = access.getRecommender(param.get(Helper.Keys.RecommenderId));
        if (recommender == null) {
            throw new NotFoundException("Recommender with the id %s not found.", param.get(Helper.Keys.RecommenderId));
        }
        if (recommender.getConfiguration(Helper.Keys.UserId) == null) {
            recommender.setConfiguration(new ConfigurationItem(Helper.Keys.UserId, ConfigurationItem.ConfigurationItemType.String, "", ConfigurationItem.ConfigurationItemRequirementType.Required));
        }
        if (recommender.getConfiguration(Helper.Keys.ItemId) == null) {
            recommender.setConfiguration(new ConfigurationItem(Helper.Keys.ItemId, ConfigurationItem.ConfigurationItemType.String, "", ConfigurationItem.ConfigurationItemRequirementType.Optional));
        }
        return template.transform(recommender);
    }

    private TemplateResult getRecommenderBuilder(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        RecommenderBuilder recommender = access.getRecommenderBuilder(param.get(Helper.Keys.RecommenderId));
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        if (recommender == null) {
            throw new NotFoundException("Recommender with the id %s not found.", param.get(Helper.Keys.RecommenderId));
        }
        if (recommender.getState() == RecommenderInformation.RecommenderState.AVAILABLE) {
            ConfigurationItem config = new ConfigurationItem(Helper.Keys.SourceId, ConfigurationItem.ConfigurationItemType.Options, "", ConfigurationItem.ConfigurationItemRequirementType.Required);
            ArrayList<String> dataSources = new ArrayList<String>();
            List infos = dAccess.getDataInformations();
            for (DataInformation i : infos) {
                if (i.getState() != DataInformation.DataState.READY) continue;
                dataSources.add(i.getId());
            }
            config.setOptions(dataSources);
            recommender.setConfiguration(config);
        }
        return template.transform(recommender);
    }

    private TemplateResult recommend(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommendationResult result;
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        Recommender recommender = access.getRecommender(param.get(Helper.Keys.RecommenderId));
        if (recommender == null) {
            throw new NotFoundException("A recommender with the id %s can not be found.", param.get(Helper.Keys.RecommenderId));
        }
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        DataSource source = dAccess.getDataSource(recommender.getDataSourceId());
        String userId = param.get(Helper.Keys.UserId);
        if (userId != null && !userId.isEmpty()) {
            for (Context c : this.contextProvider.getAll()) {
                if (!(c instanceof UserContext)) continue;
                ((UserContext)c).processContext(source.getSourceId(), userId, (Object)source, Helper.Keys.Context.DataSet);
                ((UserContext)c).processContext(source.getSourceId(), userId, param, Helper.Keys.Context.Params);
            }
        }
        if ((result = recommender.recommend(userId, this.contextProvider, param)) != null && recommender.getExperimentId() != null) {
            result.setExperimentId(recommender.getExperimentId());
            result.setResultId(UUID.randomUUID().toString());
            this.saveExperimentResult(result);
        }
        return template.transform(result);
    }

    private void saveExperimentResult(RecommendationResult result) {
        File dir = Helper.createOrGetDir((String)"experiments");
        File experimentFolder = Helper.createOrGetDir((String)(dir.getAbsolutePath() + System.getProperty("file.separator") + result.getExperimentId()));
        File resultFile = new File(experimentFolder.getAbsolutePath() + System.getProperty("file.separator") + result.getResultId());
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(resultFile));){
            writer.write(result.getResultId() + "\n");
            writer.write(result.getExperimentId() + "\n");
            writer.write(result.getRecommender() + "\n");
            for (RecommendedItem item : result.getItems()) {
                writer.write(item.getItemId() + ":" + item.getConfidence() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TemplateResult createRecommender(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        DataSource source = this.getDataSource(dAccess, param.get(Helper.Keys.SourceId));
        if (source.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The data source %s is not ready so far. The current state is %s.", source.getId(), source.getState().toString());
        }
        Recommender recommender = access.createRecommender(source, param);
        if (param.containsKey(Helper.Keys.ExperimentId)) {
            recommender.setExperimentId(param.get(Helper.Keys.ExperimentId));
        }
        return template.transform(recommender);
    }

    private TemplateResult updateRecommender(RecommenderTemplate template, Map<String, String> param) throws BaseException {
        RecommenderAccess access = (RecommenderAccess)this.recommenderAccess.getFirstInstance();
        DataAccess dAccess = (DataAccess)this.dataAccess.getFirstInstance();
        DataSource source = this.getDataSource(dAccess, param.get(Helper.Keys.SourceId));
        if (source.getState() != DataInformation.DataState.READY) {
            throw new NotReadyException("The data source %s is not ready so far. The current state is %s.", source.getId(), source.getState().toString());
        }
        Recommender recommender = access.updateRecommender(param.get(Helper.Keys.RecommenderId), source, param);
        return template.transform(recommender.recommend(param.get(Helper.Keys.UserId)));
    }

    private DataSource getDataSource(DataAccess access, String sourceId) throws BaseException {
        return access.getDataSource(sourceId);
    }

    @Override
    public void close() throws IOException {
        if (this.recommenderAccess != null) {
            this.context.removeServiceListener((ServiceListener)this.recommenderAccess);
        }
        if (this.dataAccess != null) {
            this.context.removeServiceListener((ServiceListener)this.dataAccess);
        }
        if (this.templates != null) {
            this.context.removeServiceListener((ServiceListener)this.templates);
        }
        if (this.contextProvider != null) {
            this.context.removeServiceListener((ServiceListener)this.contextProvider);
        }
    }
}

