/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.access;

import com.recalot.common.GenericServiceListener;
import com.recalot.common.Helper;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.communication.Message;
import com.recalot.common.exceptions.AlreadyExistsException;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.MissingArgumentException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.interfaces.model.data.DataSource;
import com.recalot.common.interfaces.model.rec.Recommender;
import com.recalot.common.interfaces.model.rec.RecommenderInformation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;

public class RecommenderAccess
implements com.recalot.common.interfaces.model.rec.RecommenderAccess,
Closeable {
    private final BundleContext context;
    private final GenericServiceListener<RecommenderBuilder> recommenderListener;
    private final ConcurrentHashMap<String, Recommender> recommender;
    private final ConcurrentHashMap<String, Thread> threads;

    public RecommenderAccess(BundleContext context) {
        this.context = context;
        this.recommenderListener = new GenericServiceListener(context, RecommenderBuilder.class.getName());
        this.recommender = new ConcurrentHashMap();
        this.threads = new ConcurrentHashMap();
        this.context.addServiceListener(this.recommenderListener);
    }

    @Override
    public void close() throws IOException {
        if (this.threads != null) {
            this.threads.values().forEach(Thread::interrupt);
        }
        if (this.recommenderListener != null) {
            this.context.removeServiceListener(this.recommenderListener);
        }
    }

    public String getKey() {
        return "recommender-access";
    }

    public String getDescription() {
        return null;
    }

    public RecommenderInformation[] getRecommenders() throws BaseException {
        ArrayList<Recommender> allAvailableRecommender = new ArrayList<Recommender>();
        allAvailableRecommender.addAll(this.recommender.values());
        allAvailableRecommender.addAll(this.recommenderListener.getAll());
        return allAvailableRecommender.toArray(new RecommenderInformation[allAvailableRecommender.size()]);
    }

    public Recommender getRecommender(String id) throws BaseException {
        return this.recommender.get(id);
    }

    public RecommenderBuilder getRecommenderBuilder(String id) throws BaseException {
        return (RecommenderBuilder)this.recommenderListener.getInstance(id);
    }

    public Recommender createRecommender(DataSource dataSource, Map<String, String> param) throws BaseException {
        return this.createRecommender(dataSource, "", param);
    }

    public Recommender createRecommender(final DataSource dataSource, String configPrefix, Map<String, String> param) throws BaseException {
        String id = param.get(Helper.Keys.RecommenderBuilderId);
        String wishedId = param.get(Helper.Keys.ID);
        if (wishedId == null || wishedId.equals("")) {
            throw new MissingArgumentException("The argument id is missing.");
        }
        if (this.recommender.containsKey(wishedId)) {
            throw new AlreadyExistsException("A recommender with the id %s already exists. Please define another id or use the updateRecommender function.", wishedId);
        }
        RecommenderBuilder builder = (RecommenderBuilder)this.recommenderListener.getInstance(id);
        final Recommender instance = (Recommender)builder.createInstance(wishedId, configPrefix, param);
        instance.setId(wishedId);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    instance.setState(RecommenderInformation.RecommenderState.TRAINING);
                    instance.setDataSourceId(dataSource.getSourceId());
                    instance.setDataSet(dataSource.getDataSet());
                    instance.train();
                    instance.setState(RecommenderInformation.RecommenderState.READY);
                    RecommenderAccess.this.threads.remove(instance.getId());
                }
                catch (BaseException e) {
                    e.printStackTrace();
                }
            }
        };
        this.threads.put(instance.getId(), thread);
        thread.start();
        this.recommender.put(instance.getId(), instance);
        return instance;
    }

    public Recommender updateRecommender(final String id, final DataSource dataSource, Map<String, String> param) throws BaseException {
        Recommender instance = this.recommender.get(id);
        if (instance == null) {
            throw new NotFoundException("Recommender with the id %s can not be found.", id);
        }
        RecommenderBuilder defaultInstance = (RecommenderBuilder)this.recommenderListener.getInstance(instance.getKey());
        final Recommender newInstance = (Recommender)defaultInstance.createInstance(id, param);
        newInstance.setState(RecommenderInformation.RecommenderState.TRAINING);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    newInstance.setDataSourceId(dataSource.getSourceId());
                    newInstance.setDataSet(dataSource.getDataSet());
                    newInstance.train();
                    newInstance.setState(RecommenderInformation.RecommenderState.READY);
                    RecommenderAccess.this.recommender.put(id, newInstance);
                    RecommenderAccess.this.threads.remove(newInstance.getId());
                }
                catch (BaseException e) {
                    e.printStackTrace();
                }
            }
        };
        this.threads.put(newInstance.getId(), thread);
        thread.start();
        return newInstance;
    }

    public Message deleteRecommender(String id) {
        if (this.threads.containsKey(id)) {
            this.threads.get(id).interrupt();
            this.threads.remove(id);
        }
        if (this.recommender.containsKey(id)) {
            this.recommender.remove(id);
        }
        return new Message("Successful deleted.", String.format("The recommender with the id '%s' was successfully deleted", id), Message.Status.INFO);
    }
}

