/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.felix.webconsole.internal.servlet.Base64;

class Password {
    private static final String DEFAULT_HASH_ALGO = "SHA-256";
    private final String hashAlgo;
    private final byte[] password;

    static boolean isPasswordHashed(String textPassword) {
        return Password.getEndOfHashAlgorithm(textPassword) >= 0;
    }

    static String hashPassword(String textPassword) {
        byte[] bytePassword = Base64.getBytesUtf8(textPassword);
        return Password.hashPassword(DEFAULT_HASH_ALGO, bytePassword);
    }

    Password(String textPassword) {
        this.hashAlgo = Password.getPasswordHashAlgorithm(textPassword);
        this.password = Password.getPasswordBytes(textPassword);
    }

    boolean matches(byte[] toCompare) {
        return Arrays.equals(this.password, Password.hashPassword(toCompare, this.hashAlgo));
    }

    public String toString() {
        return Password.hashPassword(this.hashAlgo, this.password);
    }

    private static String hashPassword(String hashAlgorithm, byte[] password) {
        String actualHashAlgo = hashAlgorithm == null ? DEFAULT_HASH_ALGO : hashAlgorithm;
        byte[] hashedPassword = Password.hashPassword(password, actualHashAlgo);
        StringBuffer buf = new StringBuffer(2 + actualHashAlgo.length() + hashedPassword.length * 3);
        buf.append('{').append(actualHashAlgo.toLowerCase()).append('}');
        buf.append(Base64.newStringUtf8(Base64.encodeBase64(hashedPassword)));
        return buf.toString();
    }

    private static String getPasswordHashAlgorithm(String textPassword) {
        int endHash = Password.getEndOfHashAlgorithm(textPassword);
        if (endHash >= 0) {
            return textPassword.substring(1, endHash);
        }
        return null;
    }

    private static byte[] getPasswordBytes(String textPassword) {
        int endHash = Password.getEndOfHashAlgorithm(textPassword);
        if (endHash >= 0) {
            String encodedPassword = textPassword.substring(endHash + 1);
            return Base64.decodeBase64(encodedPassword);
        }
        return Base64.getBytesUtf8(textPassword);
    }

    private static int getEndOfHashAlgorithm(String textPassword) {
        int endHash;
        if (textPassword.startsWith("{") && (endHash = textPassword.indexOf("}")) > 0) {
            return endHash;
        }
        return -1;
    }

    private static byte[] hashPassword(byte[] pwd, String hashAlg) {
        if (hashAlg == null || hashAlg.length() == 0) {
            return pwd;
        }
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlg);
            return md.digest(pwd);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot hash the password: " + e);
        }
    }
}

