/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec;

import com.recalot.common.builder.Initiator;
import com.recalot.common.builder.RecommenderBuilder;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.context.Context;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.context.LastVisitedContext;
import com.recalot.model.rec.context.ParamsContext;
import com.recalot.model.rec.context.UserInputContext;
import com.recalot.model.rec.recommender.bprmf.BPRMFRecommender;
import com.recalot.model.rec.recommender.experiments.GlobalAverageRatingRecommender;
import com.recalot.model.rec.recommender.experiments.GlobalItemAverageRatingRecommender;
import com.recalot.model.rec.recommender.experiments.GlobalUserAverageRatingRecommender;
import com.recalot.model.rec.recommender.knn.UserBasedCosineNearestNeighborsRecommender;
import com.recalot.model.rec.recommender.memory.userKNN.LiveUserCosKNN;
import com.recalot.model.rec.recommender.reddit.ContextAwareBPRRecommender;
import com.recalot.model.rec.recommender.reddit.ContextAwareMostPopular;
import com.recalot.model.rec.recommender.reddit.ContextAwareRandomRecommender;
import com.recalot.model.rec.recommender.reddit.RandomRecommender;
import com.recalot.model.rec.recommender.slopeone.SlopeOneRecommender;
import com.recalot.model.rec.recommender.social.SocialMostPopularRecommender;
import com.recalot.model.rec.recommender.wallpaper.mostpopular.MostPopularRecommender;
import com.recalot.model.rec.recommender.wallpaper.survey.SurveyRecommender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
Initiator {
    private List<RecommenderBuilder> recommenders;
    private List<Context> contexts;

    public void start(BundleContext context) {
        this.registerRecommenders(context);
        this.registerContext(context);
    }

    private void registerContext(BundleContext context) {
        this.contexts = new ArrayList<Context>();
        this.contexts.add((Context)new LastVisitedContext());
        this.contexts.add((Context)new ParamsContext());
        this.contexts.add((Context)new UserInputContext());
        for (Context c : this.contexts) {
            context.registerService(Context.class.getName(), (Object)c, null);
        }
    }

    private void registerRecommenders(BundleContext context) {
        this.recommenders = new ArrayList<RecommenderBuilder>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mp", com.recalot.model.rec.recommender.mostpopular.MostPopularRecommender.class.getName());
        map.put("social-mp", SocialMostPopularRecommender.class.getName());
        map.put("wallpaper-survey", SurveyRecommender.class.getName());
        map.put("wallpaper-mp", MostPopularRecommender.class.getName());
        map.put("cosine-user-knn", UserBasedCosineNearestNeighborsRecommender.class.getName());
        map.put("slopeone", SlopeOneRecommender.class.getName());
        map.put("bprmf", BPRMFRecommender.class.getName());
        map.put("live-user-knn", LiveUserCosKNN.class.getName());
        map.put("random", com.recalot.model.rec.recommender.random.RandomRecommender.class.getName());
        map.put("item-average-rating", GlobalItemAverageRatingRecommender.class.getName());
        map.put("user-average-rating", GlobalUserAverageRatingRecommender.class.getName());
        map.put("global-average-rating", GlobalAverageRatingRecommender.class.getName());
        map.put("reddit-bprmf", com.recalot.model.rec.recommender.reddit.MostPopularRecommender.class.getName());
        map.put("reddit-context-bprmf", ContextAwareBPRRecommender.class.getName());
        map.put("reddit-context-mp", ContextAwareMostPopular.class.getName());
        map.put("reddit-context-random", ContextAwareRandomRecommender.class.getName());
        map.put("reddit-random", RandomRecommender.class.getName());
        map.put("reddit-mp", com.recalot.model.rec.recommender.reddit.MostPopularRecommender.class.getName());
        for (String key : map.keySet()) {
            try {
                ConfigurationItem[] items;
                RecommenderBuilder builder = new RecommenderBuilder((Initiator)this, (String)map.get(key), key, "");
                for (ConfigurationItem item : items = Activator.getConfigurationItems((String)map.get(key))) {
                    builder.setConfiguration(item);
                }
                this.recommenders.add(builder);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        for (RecommenderBuilder c : this.recommenders) {
            context.registerService(RecommenderBuilder.class.getName(), (Object)c, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.recommenders != null) {
            for (RecommenderBuilder recommenderBuilder : this.recommenders) {
                recommenderBuilder.close();
            }
            this.recommenders = null;
        }
        if (this.contexts != null) {
            for (Context context2 : this.contexts) {
                context2.close();
            }
            this.contexts = null;
        }
    }

    public Object createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ConfigurationItem[] getConfigurationItems(String className) {
        HashMap<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();
        try {
            for (Class<?> recommender = Class.forName(className); recommender != null; recommender = recommender.getSuperclass()) {
                Configuration[] annotations;
                Configuration config;
                if (recommender.isAnnotationPresent(Configuration.class) && (config = recommender.getAnnotation(Configuration.class)) != null && !items.containsKey(config.key())) {
                    items.put(config.key(), new ConfigurationItem(config.key(), config.type(), config.value(), config.requirement(), config.description(), new ArrayList<String>(Arrays.asList(config.options()))));
                }
                if (!recommender.isAnnotationPresent(Configurations.class)) continue;
                for (Configuration t : annotations = recommender.getAnnotation(Configurations.class).value()) {
                    if (items.containsKey(t.key())) continue;
                    items.put(t.key(), new ConfigurationItem(t.key(), t.type(), t.value(), t.requirement(), t.description(), new ArrayList<String>(Arrays.asList(t.options()))));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return items.values().toArray(new ConfigurationItem[items.size()]);
    }
}

