/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.funksvd.helper;

import com.recalot.model.rec.recommender.funksvd.helper.RandomUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class FastSet<K>
implements Set<K>,
Cloneable {
    private static final Object REMOVED = new Object();
    private K[] keys;
    private int numEntries;
    private int numSlotsUsed;

    public FastSet() {
        this(5);
    }

    public FastSet(Collection<? extends K> c) {
        this(c.size());
        this.addAll(c);
    }

    public FastSet(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        if (size >= 1073741474) {
            throw new IllegalArgumentException("size must be less than 1073741474");
        }
        int hashSize = RandomUtils.nextTwinPrime(2 * size);
        this.keys = new Object[hashSize];
    }

    K[] getKeys() {
        return this.keys;
    }

    private int find(Object key) {
        int theHashCode = key.hashCode() & Integer.MAX_VALUE;
        K[] keys = this.keys;
        int hashSize = keys.length;
        int jump = 1 + theHashCode % (hashSize - 2);
        int index = theHashCode % hashSize;
        K currentKey = keys[index];
        while (!(currentKey == null || currentKey != REMOVED && key.equals(currentKey))) {
            index = index < jump ? (index += hashSize - jump) : (index -= jump);
            currentKey = keys[index];
        }
        return index;
    }

    @Override
    public int size() {
        return this.numEntries;
    }

    @Override
    public boolean isEmpty() {
        return this.numEntries == 0;
    }

    @Override
    public boolean contains(Object key) {
        return key != null && this.keys[this.find(key)] != null;
    }

    @Override
    public boolean add(K key) {
        int index;
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.numSlotsUsed >= this.keys.length >> 1) {
            if (this.numEntries >= this.numSlotsUsed >> 1) {
                this.growAndRehash();
            } else {
                this.rehash();
            }
        }
        if (this.keys[index = this.find(key)] == null) {
            this.keys[index] = key;
            ++this.numEntries;
            ++this.numSlotsUsed;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<K> iterator() {
        return new KeyIterator();
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        int index = this.find(key);
        if (this.keys[index] == null) {
            return false;
        }
        this.keys[index] = REMOVED;
        --this.numEntries;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (o != null && this.keys[this.find(o)] != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends K> c) {
        boolean changed = false;
        for (K k : c) {
            if (!this.add(k)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<K> iterator = this.iterator();
        while (iterator.hasNext()) {
            K k = iterator.next();
            if (c.contains(k)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        Arrays.fill(this.keys, null);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.numEntries]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.numEntries) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.numEntries);
        }
        int keyOffset = 0;
        int resultOffset = 0;
        while (resultOffset < a.length) {
            K key;
            if ((key = this.keys[keyOffset++]) == null || key == REMOVED) continue;
            a[resultOffset++] = key;
        }
        return a;
    }

    private void growAndRehash() {
        if (this.keys.length >= 1073741474) {
            throw new IllegalStateException("Can't grow any more");
        }
        this.rehash(RandomUtils.nextTwinPrime(this.keys.length << 1));
    }

    public void rehash() {
        this.rehash(RandomUtils.nextTwinPrime(this.numEntries << 1));
    }

    private void rehash(int newHashSize) {
        K[] oldKeys = this.keys;
        this.numEntries = 0;
        this.numSlotsUsed = 0;
        this.keys = new Object[newHashSize];
        for (K key : oldKeys) {
            if (key == null || key == REMOVED) continue;
            this.add(key);
        }
    }

    public int intersectionSize(FastSet<?> other) {
        K[] otherKeys;
        int count = 0;
        for (K key : otherKeys = other.keys) {
            if (key == null || key == REMOVED || this.keys[this.find(key)] == null) continue;
            ++count;
        }
        return count;
    }

    public FastSet<K> clone() {
        FastSet clone;
        try {
            clone = (FastSet)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError();
        }
        clone.keys = new Object[this.keys.length];
        System.arraycopy(this.keys, 0, clone.keys, 0, this.keys.length);
        return clone;
    }

    private final class KeyIterator
    implements Iterator<K> {
        private int position;
        private int lastNext = -1;

        private KeyIterator() {
        }

        @Override
        public boolean hasNext() {
            this.goToNext();
            return this.position < FastSet.this.getKeys().length;
        }

        @Override
        public K next() {
            this.goToNext();
            this.lastNext = this.position;
            K[] keys = FastSet.this.getKeys();
            if (this.position >= keys.length) {
                throw new NoSuchElementException();
            }
            return keys[this.position++];
        }

        private void goToNext() {
            K[] keys = FastSet.this.getKeys();
            int length = keys.length;
            while (this.position < length && (keys[this.position] == null || keys[this.position] == REMOVED)) {
                ++this.position;
            }
        }

        @Override
        public void remove() {
            if (this.lastNext >= FastSet.this.keys.length) {
                throw new NoSuchElementException();
            }
            if (this.lastNext < 0) {
                throw new IllegalStateException();
            }
            ((FastSet)FastSet.this).keys[this.lastNext] = REMOVED;
            FastSet.this.numEntries--;
        }
    }
}

