/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.helper;

import com.recalot.common.Helper;
import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.Interaction;
import com.recalot.common.exceptions.BaseException;
import java.util.HashMap;
import java.util.Map;

public class RecommenderHelper {
    public static Map<String, Double> getUserAverageRatings(DataSet dataSet) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        HashMap<String, Integer> counters = new HashMap<String, Integer>();
        try {
            for (Interaction r : dataSet.getInteractions()) {
                Double userAvg = (Double)result.get(r.getItemId());
                if (!Helper.isIntegerRegex((String)r.getValue())) continue;
                Integer value = Integer.parseInt(r.getValue());
                if (userAvg == null) {
                    userAvg = new Double(value.intValue());
                    result.put(r.getId(), userAvg);
                    counters.put(r.getUserId(), 1);
                    continue;
                }
                counters.put(r.getUserId(), (Integer)counters.get(r.getUserId()) + 1);
                result.put(r.getUserId(), (Double)result.get(r.getUserId()) + (double)value.intValue());
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        for (String user : result.keySet()) {
            result.put(user, (Double)result.get(user) / (double)((Integer)counters.get(user)).intValue());
        }
        return result;
    }

    public static double getGlobalRatingAverage(DataSet dataSet) {
        int cnt = 0;
        int total = 0;
        try {
            for (Interaction rating : dataSet.getInteractions()) {
                if (!Helper.isIntegerRegex((String)rating.getValue())) continue;
                total += Integer.parseInt(rating.getValue());
                ++cnt;
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        return (double)total / (double)cnt;
    }
}

