/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.reddit;

import com.recalot.common.Helper;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.context.UserContext;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.rec.recommender.reddit.ContextHelper;
import com.recalot.model.rec.recommender.reddit.RandomRecommender;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Configuration(key="contextType", type=ConfigurationItem.ConfigurationItemType.Options, value="letter", options={"letter", "last", "both"}, requirement=ConfigurationItem.ConfigurationItemRequirementType.Required)
public class ContextAwareRandomRecommender
extends RandomRecommender {
    private String contextType;
    private ContextHelper contextHelper;

    @Override
    public void train() throws BaseException {
        super.train();
        this.contextHelper = new ContextHelper(this.getDataSourceId());
        this.contextHelper.train(this.getDataSet());
    }

    @Override
    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) throws BaseException {
        UserContext userInputContext = (UserContext)context.getInstance("user-input");
        UserContext userLastItemContext = (UserContext)context.getInstance("user-last-visited");
        List<Object> items = super.recommend(userId, context, param).getItems();
        if (items == null) {
            items = new ArrayList<RecommendedItem>();
        }
        switch (this.contextType) {
            case "letter": {
                items = this.contextHelper.applyLetterContext(items, userId, userInputContext);
                break;
            }
            case "last": {
                items = this.contextHelper.applyLastWordsContext(items, userId, userLastItemContext);
                break;
            }
            case "both": {
                items = this.contextHelper.applyBothContext(items, userId, userInputContext, userLastItemContext);
            }
        }
        items = Helper.applySubList(items, param, (int)10);
        return new RecommendationResult(this.getId(), items);
    }

    @Override
    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) throws BaseException {
        return super.predict(userId, itemId, context, param);
    }

    public void setContextType(String contextType) {
        this.contextType = contextType;
    }
}

