/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.slopeone;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.User;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SlopeOneRecommender
extends Recommender {
    private HashMap<String, Map<String, Integer>> mFreqMatrix;
    private HashMap<String, Map<String, Float>> mDiffMatrix;

    public SlopeOneRecommender() {
        this.setKey("slopeone");
    }

    public void train() throws BaseException {
        this.mDiffMatrix = new HashMap();
        this.mFreqMatrix = new HashMap();
        for (User user : this.getDataSet().getUsers()) {
            for (Interaction interaction1 : this.getDataSet().getInteractions(user.getId())) {
                if (!this.mDiffMatrix.containsKey(interaction1.getItemId())) {
                    this.mDiffMatrix.put(interaction1.getItemId(), new HashMap());
                    this.mFreqMatrix.put(interaction1.getItemId(), new HashMap());
                }
                for (Interaction interaction2 : this.getDataSet().getInteractions(user.getId())) {
                    int oldcount = 0;
                    if (this.mFreqMatrix.get(interaction1.getItemId()).containsKey(interaction2.getItemId())) {
                        oldcount = this.mFreqMatrix.get(interaction1.getItemId()).get(interaction2.getItemId());
                    }
                    float olddiff = 0.0f;
                    if (this.mDiffMatrix.get(interaction1.getItemId()).containsKey(interaction2.getItemId())) {
                        olddiff = this.mDiffMatrix.get(interaction1.getItemId()).get(interaction2.getItemId()).floatValue();
                    }
                    float observeddiff = Integer.parseInt(interaction1.getValue()) - Integer.parseInt(interaction2.getValue());
                    this.mFreqMatrix.get(interaction1.getItemId()).put(interaction2.getItemId(), oldcount + 1);
                    this.mDiffMatrix.get(interaction1.getItemId()).put(interaction2.getItemId(), Float.valueOf(olddiff + observeddiff));
                }
            }
        }
        for (String j : this.mDiffMatrix.keySet()) {
            for (String i : this.mDiffMatrix.get(j).keySet()) {
                float oldvalue = this.mDiffMatrix.get(j).get(i).floatValue();
                int count = this.mFreqMatrix.get(j).get(i);
                this.mDiffMatrix.get(j).put(i, Float.valueOf(oldvalue / (float)count));
            }
        }
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        List<RecommendedItem> items = new ArrayList();
        try {
            List rec = this.recommendItemsByRatingPrediction(userId, true);
            for (String key : rec) {
                items.add(new RecommendedItem(key, 0.0));
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        items = Helper.applySubList(items, param, (int)10);
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        double prediction = 0.0;
        int frequency = 0;
        try {
            for (Interaction rj : this.getDataSet().getInteractions(userId)) {
                Float avgDiff;
                Map<String, Float> diffsForItem = this.mDiffMatrix.get(itemId);
                if (diffsForItem == null || (avgDiff = diffsForItem.get(rj.getItemId())) == null) continue;
                int frq = this.mFreqMatrix.get(itemId).get(rj.getItemId());
                float newval = (avgDiff.floatValue() + (float)Integer.parseInt(rj.getValue())) * (float)frq;
                prediction += (double)newval;
                frequency += this.mFreqMatrix.get(itemId).get(rj.getItemId()).intValue();
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
            return Double.NaN;
        }
        if (frequency > 0) {
            prediction /= (double)frequency;
        }
        if (prediction == 0.0) {
            return Double.NaN;
        }
        return prediction;
    }
}

