/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.social;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.communication.Relation;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Configuration(key="relationshipType", options={"Group", "Friend", "Trust"}, type=ConfigurationItem.ConfigurationItemType.Options)
public class SocialMostPopularRecommender
extends Recommender {
    private String relationshipType;
    private Map<String, Integer> mostPopular;

    public SocialMostPopularRecommender() {
        this.setKey("social-mp");
    }

    public void train() throws BaseException {
        this.mostPopular = new LinkedHashMap<String, Integer>();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            Helper.incrementMapValue(this.mostPopular, (Object)interaction.getItemId());
        }
        this.mostPopular = Helper.sortByValueDescending(this.mostPopular);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return 0.0;
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        Map count = new LinkedHashMap();
        try {
            Relation[] relations;
            block13: for (Relation r : relations = this.getDataSet().getRelationsFor(userId)) {
                if (!r.getType().toLowerCase().equals(this.relationshipType.toLowerCase())) continue;
                switch (this.relationshipType.toLowerCase()) {
                    case "group": {
                        Relation[] groupRelations = this.getDataSet().getRelationsFor(r.getToId());
                        if (groupRelations == null) continue block13;
                        for (Relation gr : groupRelations) {
                            Interaction[] interactions;
                            if (gr.getToId().equals(userId) || (interactions = this.getDataSet().getInteractions(gr.getToId())) == null) continue;
                            for (Interaction i : interactions) {
                                Helper.incrementMapValue(count, (Object)i.getItemId());
                            }
                        }
                        continue block13;
                    }
                    case "friend": 
                    case "trust": {
                        Interaction[] interactions = this.getDataSet().getInteractions(r.getToId());
                        if (interactions == null) continue block13;
                        for (Interaction i : interactions) {
                            Helper.incrementMapValue(count, (Object)i.getItemId());
                        }
                        continue block13;
                    }
                }
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        count = Helper.sortByValueDescending(count);
        ArrayList result = new ArrayList(count.keySet());
        HashMap<String, Boolean> omitItems = new HashMap<String, Boolean>();
        try {
            Interaction[] userInteractions = this.getDataSet().getInteractions(userId);
            for (Interaction i : userInteractions) {
                omitItems.put(i.getItemId(), true);
            }
            for (String itemId : result) {
                omitItems.put(itemId, true);
            }
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        result.addAll(this.mostPopular.keySet());
        ArrayList<RecommendedItem> recommendedItems = new ArrayList<RecommendedItem>();
        for (String itemId : result) {
            if (omitItems.containsKey(itemId)) continue;
            recommendedItems.add(new RecommendedItem(itemId, 0.0));
        }
        return new RecommendationResult(this.getId(), recommendedItems);
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = relationshipType;
    }
}

