/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.rec.recommender.wallpaper.survey;

import com.recalot.common.Helper;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.RecommendationResult;
import com.recalot.common.communication.RecommendedItem;
import com.recalot.common.context.ContextProvider;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.interfaces.model.rec.Recommender;
import flexjson.JSONDeserializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SurveyRecommender
extends Recommender {
    private HashMap<String, LinkedHashMap<String, Integer>> categoryMP;

    public void train() throws BaseException {
        this.categoryMP = new HashMap();
        LinkedHashMap temp = new LinkedHashMap();
        for (Interaction interaction : this.getDataSet().getInteractions()) {
            if (!interaction.getType().toLowerCase().equals("rating")) continue;
            Helper.incrementMapValue(temp, (Object)interaction.getItemId(), (Integer)Integer.parseInt(interaction.getValue()));
        }
        for (Interaction interaction : this.getDataSet().getItems()) {
            String content = interaction.getValue("content");
            if (content == null || content.isEmpty()) continue;
            try {
                HashMap itemContent = (HashMap)new JSONDeserializer().deserialize(content);
                String rating = (String)itemContent.get("Rating");
                ArrayList categories = (ArrayList)itemContent.get("Categories");
                String ratingCount = (String)itemContent.get("RatingCount");
                if (rating == null || rating.isEmpty() || ratingCount == null || ratingCount.isEmpty()) continue;
                Double r = Double.parseDouble(rating);
                Integer c = Integer.parseInt(ratingCount.replace("(", "").replace(" vote)", "").replace(" votes)", ""));
                if (categories == null || categories.size() <= 0) continue;
                String cat = (String)categories.get(0);
                LinkedHashMap<String, Integer> count = this.categoryMP.get(cat);
                if (count == null) {
                    count = new LinkedHashMap();
                }
                Helper.incrementMapValue(count, (Object)interaction.getId(), (Integer)((int)Math.round(r * (double)c.intValue())));
                if (temp.containsKey(interaction.getId())) {
                    Helper.incrementMapValue(count, (Object)interaction.getId(), (Integer)((Integer)temp.get(interaction.getId())));
                }
                this.categoryMP.put(cat, count);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String key : this.categoryMP.keySet()) {
            Map count = this.categoryMP.get(key);
            count = Helper.sortByValueDescending((Map)count);
            this.categoryMP.put(key, (LinkedHashMap)count);
        }
    }

    public RecommendationResult recommend(String userId, ContextProvider context, Map<String, String> param) {
        Random r = new Random();
        Interaction[] interactions = null;
        try {
            interactions = this.getDataSet().getInteractions(userId);
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (interactions != null) {
            List<Interaction> inter = Arrays.asList(interactions);
            for (String key : this.categoryMP.keySet()) {
                Map catMP = this.categoryMP.get(key);
                ArrayList items = new ArrayList(catMP.keySet());
                boolean found = false;
                int max = 10;
                for (int n = 0; !found && n < max; ++n) {
                    int next = r.nextInt(100) % 10;
                    if (next >= items.size()) continue;
                    String itemId = (String)items.get(next);
                    if (inter.stream().anyMatch(i -> i.getItemId().equals(itemId))) continue;
                    found = true;
                    result.add(itemId);
                }
            }
        }
        ArrayList<RecommendedItem> items = new ArrayList<RecommendedItem>();
        for (String key : result) {
            try {
                items.add(new RecommendedItem(this.getDataSet().getItem(key), 0.0));
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        int max = items.size();
        if (param.containsKey("count")) {
            max = Integer.parseInt(param.get("count"));
        }
        while (items.size() > max) {
            int next = r.nextInt(items.size() * 10) % items.size();
            items.remove(next);
        }
        return new RecommendationResult(this.getId(), items);
    }

    public Double predict(String userId, String itemId, ContextProvider context, Map<String, String> param) {
        return 0.0;
    }
}

