/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.metrics.list;

import com.recalot.common.Helper;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.interfaces.model.experiment.ListMetric;
import java.util.HashMap;
import java.util.List;

@Configuration(key="topN", type=ConfigurationItem.ConfigurationItemType.Integer, value="10", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description="")
public class Gini
extends ListMetric {
    private int topN;
    private HashMap<String, Integer> count = new HashMap();

    public void setTopN(Integer topN) {
        this.topN = topN;
    }

    public double getResult() {
        double sum = 0.0;
        double xmean = 0.0;
        for (Integer x1 : this.count.values()) {
            xmean += (double)x1.intValue();
            for (Integer x2 : this.count.values()) {
                sum += (double)Math.abs(x2 - x1);
            }
        }
        int n = this.count.size();
        if (n > 0) {
            return sum / ((double)(n * n * 2) * (xmean / (double)n));
        }
        return 0.0;
    }

    public void addList(List<String> relevant, List<String> retrieved) {
        List<String> topNretrieved = retrieved.subList(0, this.topN);
        for (String item : topNretrieved) {
            if (!relevant.contains(item)) continue;
            Helper.incrementMapValue(this.count, (Object)item);
        }
    }

    public String getDescription() {
        return "Classical definition of the gini index by Gini, C. (1912)";
    }
}

