/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.experiments.metrics.list;

import com.recalot.common.Helper;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.interfaces.model.experiment.ListMetric;
import java.util.List;

@Configuration(key="topN", type=ConfigurationItem.ConfigurationItemType.Integer, value="10", requirement=ConfigurationItem.ConfigurationItemRequirementType.Optional, description="")
public class MRR
extends ListMetric {
    private double testRun = 0.0;
    private double sum = 0.0;
    private int topN = 0;

    public void setTopN(int topN) {
        this.topN = topN;
    }

    public double getResult() {
        if (this.testRun == 0.0) {
            return 0.0;
        }
        return this.sum / this.testRun;
    }

    public void addList(List<String> relevant, List<String> retrieved) {
        boolean count = false;
        if (relevant.size() > 0) {
            List topNretrieved = Helper.applySubList(retrieved, (int)this.topN);
            int highestIndex = Integer.MAX_VALUE;
            for (String item : topNretrieved) {
                int index;
                if (!relevant.contains(item) || highestIndex <= (index = topNretrieved.indexOf(item))) continue;
                highestIndex = index + 1;
            }
            if (highestIndex != Integer.MAX_VALUE) {
                this.sum += 1.0 / (double)highestIndex;
            }
        }
        this.testRun += 1.0;
    }

    public String getDescription() {
        return "Mean reciprocal rank";
    }
}

