/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections;

import com.recalot.common.builder.DataSourceBuilder;
import com.recalot.common.builder.Initiator;
import com.recalot.common.configuration.Configuration;
import com.recalot.common.configuration.ConfigurationItem;
import com.recalot.common.configuration.Configurations;
import com.recalot.common.exceptions.BaseException;
import com.recalot.model.data.connections.downloader.ciao.CiaoDataSource;
import com.recalot.model.data.connections.downloader.douban.DoubanDataSource;
import com.recalot.model.data.connections.downloader.filmtrust.FilmTrustDataSource;
import com.recalot.model.data.connections.downloader.jester.JesterDataSource;
import com.recalot.model.data.connections.downloader.movielens.MovieLensDataSource;
import com.recalot.model.data.connections.mysql.MySQLDataSource;
import com.recalot.model.data.connections.steam.SteamFileDataSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator,
Initiator {
    private List<DataSourceBuilder> connections;

    public void start(BundleContext context) {
        this.connections = new ArrayList<DataSourceBuilder>();
        HashMap<String, String> sources = new HashMap<String, String>();
        sources.put("ml", MovieLensDataSource.class.getName());
        sources.put("mysql", MySQLDataSource.class.getName());
        sources.put("filmtrust", FilmTrustDataSource.class.getName());
        sources.put("ciao", CiaoDataSource.class.getName());
        sources.put("jester", JesterDataSource.class.getName());
        sources.put("douban", DoubanDataSource.class.getName());
        sources.put("steam", SteamFileDataSource.class.getName());
        for (String key : sources.keySet()) {
            try {
                DataSourceBuilder builder = new DataSourceBuilder((Initiator)this, (String)sources.get(key), key, "");
                builder.appendConfiguration(Activator.getConfigurationItems((String)sources.get(key)));
                this.connections.add(builder);
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        for (DataSourceBuilder c : this.connections) {
            context.registerService(DataSourceBuilder.class.getName(), (Object)c, null);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connections != null) {
            for (DataSourceBuilder c : this.connections) {
                c.close();
            }
            this.connections = null;
        }
    }

    public Object createInstance(String className) {
        try {
            Class<?> c = Class.forName(className);
            return c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ArrayList<ConfigurationItem> getConfigurationItems(String className) {
        HashMap<String, ConfigurationItem> items = new HashMap<String, ConfigurationItem>();
        try {
            for (Class<?> recommender = Class.forName(className); recommender != null; recommender = recommender.getSuperclass()) {
                Configuration[] annotations;
                Configuration config;
                if (recommender.isAnnotationPresent(Configuration.class) && (config = recommender.getAnnotation(Configuration.class)) != null && !items.containsKey(config.key())) {
                    items.put(config.key(), new ConfigurationItem(config.key(), config.type(), config.value(), config.requirement(), config.description(), new ArrayList<String>(Arrays.asList(config.options()))));
                }
                if (!recommender.isAnnotationPresent(Configurations.class)) continue;
                for (Configuration t : annotations = recommender.getAnnotation(Configurations.class).value()) {
                    if (items.containsKey(t.key())) continue;
                    items.put(t.key(), new ConfigurationItem(t.key(), t.type(), t.value(), t.requirement(), t.description(), new ArrayList<String>(Arrays.asList(t.options()))));
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
        }
        return new ArrayList<ConfigurationItem>(items.values());
    }
}

