/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.base;

import com.recalot.common.communication.DataSet;
import com.recalot.common.communication.DataSourceDataSet;
import com.recalot.common.communication.InnerIds;
import com.recalot.common.communication.Interaction;
import com.recalot.common.communication.Item;
import com.recalot.common.communication.Message;
import com.recalot.common.communication.Relation;
import com.recalot.common.communication.User;
import com.recalot.common.exceptions.BaseException;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.common.exceptions.NotSupportedException;
import com.recalot.common.interfaces.model.data.DataSource;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class DataSourceBase
extends DataSource {
    public Map<Integer, User> users = new HashMap<Integer, User>();
    public Map<Integer, Item> items = new HashMap<Integer, Item>();
    public Map<Integer, Interaction> interactions = new HashMap<Integer, Interaction>();
    public Map<Integer, Relation> relations = new HashMap<Integer, Relation>();
    private DataSet dataSet = new DataSourceDataSet((DataSource)this);

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public Interaction[] getInteractions() throws BaseException {
        return this.interactions.values().toArray(new Interaction[this.interactions.size()]);
    }

    public int getInteractionsCount() {
        return this.interactions.size();
    }

    public Interaction[] getInteractions(String userId) throws BaseException {
        return (Interaction[])this.interactions.values().stream().filter(i -> i.getUserId().equals(userId)).toArray(Interaction[]::new);
    }

    public Interaction[] getInteractions(String itemId, String userId) throws BaseException {
        return (Interaction[])this.interactions.values().stream().filter(i -> i.getUserId().equals(userId) && i.getItemId().equals(itemId)).toArray(Interaction[]::new);
    }

    public Message addInteraction(String itemId, String userId, Date timestamp, String type, String value, Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("addInteraction");
    }

    public Item[] getItems() throws BaseException {
        return this.items.values().toArray(new Item[this.items.size()]);
    }

    public int getItemsCount() {
        return this.items.size();
    }

    public Item getItem(String itemId) throws BaseException {
        if (!this.items.containsKey(InnerIds.getId((String)itemId))) {
            throw new NotFoundException("Item with id %s cannot be found.", "" + itemId);
        }
        return this.items.get(InnerIds.getId((String)itemId));
    }

    public Item tryGetItem(String itemId) {
        return this.items.get(InnerIds.getId((String)itemId));
    }

    public User[] getUsers() throws BaseException {
        return this.users.values().toArray(new User[this.users.size()]);
    }

    public int getUsersCount() {
        return this.users.size();
    }

    public User getUser(String userId) throws BaseException {
        if (!this.users.containsKey(InnerIds.getId((String)userId))) {
            throw new NotFoundException("User with id %s cannot be found.", "" + userId);
        }
        return this.users.get(InnerIds.getId((String)userId));
    }

    public User tryGetUser(String userId) throws BaseException {
        return this.users.get(InnerIds.getId((String)userId));
    }

    public Item updateItem(String itemId, Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("updateItem");
    }

    public Item createItem(Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("createItem");
    }

    public Message deleteItem(String itemId) throws BaseException {
        throw this.throwNotSupportedException("deleteItem");
    }

    public User updateUser(String userId, Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("updateUser");
    }

    public User createUser(Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("createUser");
    }

    public Relation getRelation(String relationId) throws BaseException {
        return this.relations.get(InnerIds.getId((String)relationId));
    }

    public Relation[] getRelations(String fromId, String toId) throws BaseException {
        return (Relation[])this.relations.values().stream().filter(i -> i.getFromId().equals(fromId) && i.getToId().equals(toId)).toArray(Relation[]::new);
    }

    public Relation[] getRelationsFor(String fromId) throws BaseException {
        return (Relation[])this.relations.values().stream().filter(i -> i.getFromId().equals(fromId)).toArray(Relation[]::new);
    }

    public Relation[] getRelations() throws BaseException {
        return this.relations.values().toArray(new Relation[this.relations.size()]);
    }

    public int getRelationCount() {
        return this.relations.size();
    }

    public Relation updateRelation(String relationId, String fromId, String toId, String type, Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("updateRelation");
    }

    public Relation createRelation(String fromId, String toId, String type, Map<String, String> content) throws BaseException {
        throw this.throwNotSupportedException("createRelation");
    }

    private NotSupportedException throwNotSupportedException(String createUser) throws NotSupportedException {
        return new NotSupportedException("The method %s is not supported in this data connection. This data connection is a read only data connection.", createUser);
    }
}

