/*
 * Decompiled with CFR 0.152.
 */
package com.recalot.model.data.connections.downloader;

import com.recalot.common.Helper;
import com.recalot.common.UnZip;
import com.recalot.common.exceptions.NotFoundException;
import com.recalot.model.data.connections.base.DataSourceBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class BaseDownloaderDataSource
extends DataSourceBase {
    protected File downloadData(String name, String urlString) throws IOException, NotFoundException {
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        File recalotFolder = Helper.createOrGetDir((String)(userHome + separator + "recalot"));
        File dataFolder = Helper.createOrGetDir((String)(recalotFolder.getAbsolutePath() + separator + name));
        if (dataFolder.listFiles().length == 0) {
            URL url = new URL(urlString);
            File file = new File(url.getFile());
            this.saveUrl(recalotFolder.getAbsolutePath() + separator + file.getName(), urlString);
            this.setInfo("Unzipping file");
            UnZip.unZipIt((String)(recalotFolder.getAbsolutePath() + separator + file.getName()), (String)dataFolder.getAbsolutePath());
        }
        return dataFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUrl(String filename, String urlString) throws IOException, NotFoundException {
        InputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            HttpURLConnection con = (HttpURLConnection)new URL(urlString).openConnection();
            con.setRequestProperty("Connection", "keep-alive");
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:16.0) Gecko/20100101 Firefox/16.0");
            if (con.getResponseCode() != 200) {
                throw new NotFoundException("The url %s can not be accessed!", urlString);
            }
            int chunkSize = 65536;
            int file_size = con.getContentLength();
            in = con.getInputStream();
            fout = new FileOutputStream(filename);
            int downloaded = 0;
            byte[] data = new byte[chunkSize];
            while ((count = in.read(data, 0, chunkSize)) != -1) {
                fout.write(data, 0, count);
                this.setInfo(String.format("Downloaded %s bytes of a total %s bytes", downloaded += count, file_size));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public void close() throws IOException {
    }
}

